/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthServiceProvider;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.ws.security.oauth.ExoOAuthClient;
import org.exoplatform.ws.security.oauth.OAuthConsumerService;
import org.exoplatform.ws.security.oauth.OAuthTokenCleaner;

public final class OAuthConsumerServiceImpl
implements OAuthConsumerService {
    public static final long DEFAULT_TOKEN_ALIVE_TIME = 18000000L;
    private final HashSet<OAuthAccessor> tokens = new HashSet();
    private final HashMap<String, OAuthConsumer> consumers = new HashMap();
    private static final Log LOG = ExoLogger.getLogger((String)"ws.security.OAuthConsumerServiceImpl");
    private final ExoOAuthClient oauthClient;
    private final long tokenAliveTime;

    public OAuthConsumerServiceImpl(ExoOAuthClient oauthClient, InitParams params) {
        this(oauthClient, null, params);
    }

    public OAuthConsumerServiceImpl(ExoOAuthClient oauthClient, OAuthTokenCleaner tokenCleaner, InitParams params) {
        this.oauthClient = oauthClient;
        Iterator iterator = params.getPropertiesParamIterator();
        ValueParam t = params.getValueParam("tokenAliveTime");
        this.tokenAliveTime = t != null ? Long.parseLong(t.getValue()) * 60L * 1000L : 18000000L;
        LOG.info((Object)("Token alive time is : " + this.tokenAliveTime + " ms."));
        while (iterator.hasNext()) {
            PropertiesParam pp = (PropertiesParam)iterator.next();
            String name = pp.getName();
            String secret = pp.getProperty("secret");
            String description = pp.getProperty("description");
            String providerTokenRequestURL = pp.getProperty("provider.tokenRequestURL");
            String providerAuthorizationURL = pp.getProperty("provider.authorizationURL");
            String providerAccessTokenURL = pp.getProperty("provider.accessTokenURL");
            OAuthConsumer consumer = new OAuthConsumer(null, name, secret, new OAuthServiceProvider(providerTokenRequestURL, providerAuthorizationURL, providerAccessTokenURL));
            consumer.setProperty("name", (Object)name);
            consumer.setProperty("description", (Object)description);
            this.consumers.put(name, consumer);
        }
        if (tokenCleaner != null) {
            tokenCleaner.setTokens(this.tokens);
        } else {
            LOG.warn((Object)"Running without token cleaner. All tokens will be never expired!");
        }
    }

    public OAuthAccessor getAccessor(OAuthMessage oauthMessage) throws OAuthProblemException {
        try {
            oauthMessage.requireParameters(new String[]{"oauth_consumer_key"});
            String token = oauthMessage.getParameter("oauth_token");
            String secret = oauthMessage.getParameter("oauth_token_secret");
            Iterator<OAuthAccessor> iter = this.tokens.iterator();
            OAuthAccessor accessor = null;
            if (token != null && secret != null) {
                while (iter.hasNext()) {
                    OAuthAccessor a = iter.next();
                    if (a.accessToken != null && a.accessToken.equals(token) && a.tokenSecret != null && a.tokenSecret.equals(secret)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Access token found: " + token));
                        }
                        return a;
                    }
                    if (a.requestToken == null || !a.requestToken.equals(token) || a.tokenSecret == null || !a.tokenSecret.equals(secret)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Request token found: " + token));
                    }
                    iter.remove();
                    accessor = a;
                    break;
                }
            }
            if (accessor != null) {
                this.oauthClient.getAccessToken(accessor);
                accessor.setProperty("expired", (Object)(System.currentTimeMillis() + this.tokenAliveTime));
            } else {
                OAuthConsumer consumer = this.getConsumer(oauthMessage.getConsumerKey());
                accessor = new OAuthAccessor(consumer);
                this.oauthClient.getRequestToken(accessor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Request and access token not found or not valid, generate a new request token " + accessor.requestToken));
                }
            }
            this.tokens.add(accessor);
            return accessor;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OAuthProblemException(e.getMessage());
        }
    }

    public void removeAccessor(OAuthMessage oauthMessage) throws OAuthProblemException {
        block4: {
            try {
                String token = oauthMessage.getParameter("oauth_token");
                String secret = oauthMessage.getParameter("oauth_token_secret");
                Iterator<OAuthAccessor> iter = this.tokens.iterator();
                if (token == null || secret == null) break block4;
                while (iter.hasNext()) {
                    OAuthAccessor a = iter.next();
                    if (a.accessToken == null || !a.accessToken.equals(token) || a.tokenSecret == null || !a.tokenSecret.equals(secret)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Remove access token found: " + token));
                    }
                    iter.remove();
                    break;
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Can't remove access token.");
            }
        }
    }

    private OAuthConsumer getConsumer(String name) throws OAuthProblemException {
        OAuthConsumer consumer = this.consumers.get(name);
        if (consumer != null) {
            return consumer;
        }
        throw new OAuthProblemException("There is no appropriate consumer for '" + name + "'.");
    }
}

