/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import javax.servlet.http.Cookie;
import net.oauth.OAuthConsumer;

final class CookieUtils {
    private static final int COOKIE_MAX_AGE = 31556926;

    CookieUtils() {
    }

    static Cookie deleteCookie(Cookie c) {
        c.setMaxAge(0);
        c.setValue("");
        return c;
    }

    static Cookie findCookie(String name, Cookie[] cookies) {
        if (cookies == null || cookies.length == 0) {
            return null;
        }
        for (Cookie c : cookies) {
            if (c == null || !name.equalsIgnoreCase(c.getName())) continue;
            return c;
        }
        return null;
    }

    static Cookie createCookie(String name, String value, OAuthConsumer consumer) {
        Cookie c = new Cookie(name, value);
        int maxAge = consumer.getProperty("remmemberMaxAge") == null ? 31556926 : Integer.parseInt((String)consumer.getProperty("remmemberMaxAge"));
        c.setMaxAge(maxAge);
        return c;
    }
}

