/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class OAuthRequestWrapperFilter
implements Filter {
    private static final Log LOG = ExoLogger.getLogger((String)OAuthRequestWrapperFilter.class.getName());

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Principal principal = null;
        principal = (Principal)httpRequest.getAttribute("oauth_user_principal");
        Collection roles = (Collection)httpRequest.getAttribute("oauth_user_roles");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("User principal: " + principal + ", roles " + roles));
        }
        OAuthHttpServletRequestWrapper requestWrapper = new OAuthHttpServletRequestWrapper(httpRequest, principal, roles);
        chain.doFilter((ServletRequest)requestWrapper, response);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class OAuthHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        private final Principal principal;
        private final Collection<String> roles;
        private static final String AUTH_SCHEME = "OAUTH";

        OAuthHttpServletRequestWrapper(HttpServletRequest request, Principal principal, Collection<String> roles) {
            super(request);
            this.principal = principal;
            this.roles = roles;
        }

        public String getAuthType() {
            return AUTH_SCHEME;
        }

        public boolean isUserInRole(String role) {
            if (role == null) {
                return false;
            }
            return this.roles.contains(role);
        }

        public boolean isSecure() {
            return super.isSecure();
        }

        public Principal getUserPrincipal() {
            return this.principal;
        }

        public String getRemoteUser() {
            return this.getUserPrincipal().getName();
        }
    }
}

