/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.impl;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.ws.security.oauth.ExoOAuthClient;

public class OAuthClientHttpImpl
implements ExoOAuthClient {
    public void getAccessToken(OAuthAccessor accessor) throws Exception {
        ArrayList<OAuth.Parameter> p1 = new ArrayList<OAuth.Parameter>();
        p1.add(new OAuth.Parameter("oauth_token", accessor.requestToken));
        p1.add(new OAuth.Parameter("oauth_token_secret", accessor.tokenSecret));
        OAuthMessage request = accessor.newRequestMessage("POST", accessor.consumer.serviceProvider.accessTokenURL, p1);
        URL url = new URL(request.URL);
        List p2 = request.getParameters();
        NVPair[] nvp = new NVPair[p2.size()];
        int i = 0;
        for (Map.Entry e : p2) {
            nvp[i++] = new NVPair((String)e.getKey(), (String)e.getValue());
        }
        HTTPConnection conn = new HTTPConnection(url);
        HTTPResponse response = conn.Post(url.getPath(), nvp);
        if (response.getStatusCode() != 200) {
            throw new OAuthProblemException("Provider status code " + response.getStatusCode() + ".");
        }
        ArrayList<String> roles = new ArrayList<String>();
        List tokens = OAuth.decodeForm((String)response.getText());
        for (OAuth.Parameter token : tokens) {
            String key = token.getKey();
            String value = token.getValue();
            if ("oauth_token".equalsIgnoreCase(key)) {
                accessor.accessToken = value;
                continue;
            }
            if ("oauth_token_secret".equalsIgnoreCase(key)) {
                accessor.tokenSecret = value;
                continue;
            }
            if ("oauth_user_id".equalsIgnoreCase(key)) {
                accessor.setProperty("oauth_user_id", (Object)value);
                continue;
            }
            if ("oauth_user_role".equalsIgnoreCase(key)) {
                roles.add(value);
                continue;
            }
            accessor.setProperty(key, (Object)value);
        }
        accessor.setProperty("oauth_user_roles", roles);
        accessor.requestToken = null;
    }

    public void getRequestToken(OAuthAccessor accessor) throws Exception {
        OAuthMessage request = accessor.newRequestMessage("POST", accessor.consumer.serviceProvider.requestTokenURL, null);
        List p = request.getParameters();
        URL url = new URL(request.URL);
        NVPair[] p1 = new NVPair[p.size()];
        for (int i = 0; i < p1.length; ++i) {
            p1[i] = new NVPair((String)((Map.Entry)p.get(i)).getKey(), (String)((Map.Entry)p.get(i)).getValue());
        }
        HTTPConnection conn = new HTTPConnection(url);
        HTTPResponse response = conn.Post(url.getPath(), p1);
        if (response.getStatusCode() != 200) {
            throw new OAuthProblemException("Provider status code " + response.getStatusCode() + ".");
        }
        List tokens = OAuth.decodeForm((String)response.getText());
        for (OAuth.Parameter token : tokens) {
            String key = token.getKey();
            String value = token.getValue();
            if ("oauth_token".equalsIgnoreCase(key)) {
                accessor.requestToken = value;
                continue;
            }
            if ("oauth_token_secret".equalsIgnoreCase(key)) {
                accessor.tokenSecret = value;
                continue;
            }
            accessor.setProperty(key, (Object)value);
        }
        accessor.accessToken = null;
    }
}

