/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthServiceProvider;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.security.oauth.ExoOAuthClient;
import org.exoplatform.ws.security.oauth.OAuthConsumerService;
import org.exoplatform.ws.security.oauth.storage.GrantedAccessorStorage;
import org.exoplatform.ws.security.oauth.storage.GrantedAccessorStorageProperties;

public final class OAuthConsumerServiceImpl
implements OAuthConsumerService {
    private static final Log LOG = ExoLogger.getLogger((String)"ws.security.OAuthConsumerServiceImpl");
    private final Map<String, OAuthAccessor> requestAccessors = new ConcurrentHashMap<String, OAuthAccessor>();
    private final GrantedAccessorStorage grantedAccessors;
    private final Map<String, OAuthConsumer> consumers = new HashMap<String, OAuthConsumer>();
    private final ExoOAuthClient oauthClient;

    public OAuthConsumerServiceImpl(InitParams params) throws Exception {
        ValueParam t = params.getValueParam("consumer.client");
        if (t == null) {
            throw new RuntimeException("oAuth token storage is not configured, check configuration.");
        }
        this.oauthClient = (ExoOAuthClient)Class.forName(t.getValue()).newInstance();
        t = params.getValueParam("consumer.storage");
        if (t == null) {
            throw new RuntimeException("oAuth token storage is not configured, check configuration.");
        }
        this.grantedAccessors = (GrantedAccessorStorage)Class.forName(t.getValue()).newInstance();
        ObjectParameter tokenStorageProperties = params.getObjectParam("consumer.storage.properties");
        if (tokenStorageProperties != null) {
            this.grantedAccessors.init((GrantedAccessorStorageProperties)tokenStorageProperties.getObject());
        }
        Iterator iterator = params.getPropertiesParamIterator();
        while (iterator.hasNext()) {
            PropertiesParam p = (PropertiesParam)iterator.next();
            String name = p.getName();
            String secret = p.getProperty("consumer.secret");
            String description = p.getProperty("consumer.description");
            String providerTokenRequestURL = p.getProperty("provider.tokenRequestURL");
            String providerAuthorizationURL = p.getProperty("provider.authorizationURL");
            String providerAccessTokenURL = p.getProperty("provider.accessTokenURL");
            OAuthConsumer consumer = new OAuthConsumer(null, name, secret, new OAuthServiceProvider(providerTokenRequestURL, providerAuthorizationURL, providerAccessTokenURL));
            consumer.setProperty("consumer.name", (Object)name);
            consumer.setProperty("consumer.description", (Object)description);
            consumer.setProperty("remmemberMaxAge", (Object)p.getProperty("remmemberMaxAge"));
            this.consumers.put(name, consumer);
        }
    }

    public OAuthAccessor getAccessor(OAuthMessage oauthMessage) throws OAuthProblemException {
        try {
            oauthMessage.requireParameters(new String[]{"oauth_consumer_key"});
            String token = oauthMessage.getParameter("oauth_token");
            String secret = oauthMessage.getParameter("oauth_token_secret");
            OAuthAccessor accessor = null;
            if (token != null && secret != null) {
                accessor = this.grantedAccessors.getAccessor(token, secret);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Access token found: " + token));
                }
                if (accessor != null) {
                    return accessor;
                }
                accessor = this.requestAccessors.remove(token);
                if (accessor != null && accessor.tokenSecret != null) {
                    if (secret == null || !secret.equals(accessor.tokenSecret)) {
                        throw new OAuthProblemException("Secret token is invalid or null.");
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Request token found: " + token));
                    }
                }
            }
            if (accessor != null) {
                this.oauthClient.getAccessToken(accessor);
                this.grantedAccessors.addAccessor(accessor);
            } else {
                OAuthConsumer consumer = this.getConsumer(oauthMessage.getConsumerKey());
                accessor = new OAuthAccessor(consumer);
                this.oauthClient.getRequestToken(accessor);
                this.requestAccessors.put(accessor.requestToken, accessor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Request and access token not found or not valid, generate a new request token " + accessor.requestToken));
                }
            }
            return accessor;
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new OAuthProblemException(e.getMessage());
        }
    }

    public void removeAccessor(OAuthMessage oauthMessage) throws OAuthProblemException {
        block2: {
            try {
                String token = oauthMessage.getParameter("oauth_token");
                this.grantedAccessors.removeAccessor(token);
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block2;
                e.printStackTrace();
            }
        }
    }

    private OAuthConsumer getConsumer(String name) throws OAuthProblemException {
        OAuthConsumer consumer = this.consumers.get(name);
        if (consumer != null) {
            return consumer;
        }
        throw new OAuthProblemException("There is no appropriate consumer for " + name);
    }
}

