/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ws.security.oauth.OAuthProviderService;

public class OAuthRequestTokenServlet
extends HttpServlet {
    private static final long serialVersionUID = -6887490497735057738L;

    public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        OAuthConsumer consumer;
        OAuthMessage oauthMessage = OAuthServlet.getMessage((HttpServletRequest)httpRequest, null);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OAuthProviderService providerService = (OAuthProviderService)container.getComponentInstanceOfType(OAuthProviderService.class);
        try {
            consumer = providerService.getConsumer(oauthMessage);
        }
        catch (OAuthProblemException e) {
            httpResponse.sendError(401, "Consumer key is invalid!");
            return;
        }
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        try {
            oauthMessage.validateSignature(accessor);
        }
        catch (Exception e) {
            httpResponse.sendError(401, "Signature validation failed!");
            return;
        }
        providerService.generateRequestToken(accessor);
        httpResponse.setContentType("text/plain");
        ServletOutputStream out = httpResponse.getOutputStream();
        OAuth.formEncode((Iterable)OAuth.newList((String[])new String[]{"oauth_token", accessor.requestToken, "oauth_token_secret", accessor.tokenSecret}), (OutputStream)out);
        out.flush();
        out.close();
    }
}

