/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.security.oauth.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.server.OAuthServlet;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.ws.security.oauth.OAuthProviderService;

public class OAuthAccessTokenServlet
extends HttpServlet {
    private static final long serialVersionUID = 2950381189568117176L;
    private static final Log LOG = ExoLogger.getLogger((String)OAuthAccessTokenServlet.class.getName());

    public void service(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws ServletException, IOException {
        OAuthAccessor accessor;
        OAuthMessage oauthMessage = OAuthServlet.getMessage((HttpServletRequest)httpRequest, null);
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OAuthProviderService providerService = (OAuthProviderService)container.getComponentInstanceOfType(OAuthProviderService.class);
        try {
            accessor = providerService.getAccessor(oauthMessage);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Accessor: " + accessor));
            }
        }
        catch (OAuthProblemException e) {
            e.printStackTrace();
            httpResponse.sendError(401, "Request token is invalid!");
            return;
        }
        try {
            oauthMessage.validateSignature(accessor);
        }
        catch (Exception e) {
            e.printStackTrace();
            httpResponse.sendError(401, "Signature validation failed!");
            return;
        }
        if (!Boolean.TRUE.equals(accessor.getProperty("authorized"))) {
            httpResponse.sendError(401, "Request token is not authorized!");
            return;
        }
        try {
            providerService.generateAccessToken(accessor);
        }
        catch (OAuthProblemException e) {
            e.printStackTrace();
            httpResponse.sendError(401, "Can't generate access token!");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(accessor.accessToken + "/" + accessor.tokenSecret));
        }
        httpResponse.setContentType("text/plain");
        ServletOutputStream out = httpResponse.getOutputStream();
        OAuth.formEncode((Iterable)OAuth.newList((String[])this.createParametersList(accessor)), (OutputStream)out);
        out.flush();
        out.close();
    }

    private String[] createParametersList(OAuthAccessor accessor) {
        ArrayList<String> l = new ArrayList<String>();
        l.add("oauth_token");
        l.add(accessor.accessToken);
        l.add("oauth_token_secret");
        l.add(accessor.tokenSecret);
        l.add("oauth_user_id");
        l.add((String)accessor.getProperty("oauth_user_id"));
        Collection s = (Collection)accessor.getProperty("oauth_user_roles");
        for (String r : s) {
            l.add("oauth_user_role");
            l.add(r);
        }
        return l.toArray(new String[l.size()]);
    }
}

