/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.impl.cxf;

import java.util.ArrayList;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.ws.AbstractMultiWebService;
import org.exoplatform.services.ws.AbstractSingletonWebService;
import org.exoplatform.services.ws.impl.cxf.CXFUtils;
import org.exoplatform.services.ws.impl.cxf.WebServiceLoaderPlugin;

public class WebServiceLoader {
    private ExoContainer container;
    private List<AbstractSingletonWebService> singleservices;
    private List<AbstractMultiWebService> multiservices;
    private static final Log LOG = ExoLogger.getLogger(WebServiceLoader.class);
    private final List<Class<?>> jcs = new ArrayList();

    public WebServiceLoader(ExoContainerContext containerContext) {
        this.container = containerContext.getContainer();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WebServiceLoader.WebServiceLoader() container = " + this.container));
        }
    }

    public void init() {
        String address;
        this.singleservices = this.container.getComponentInstancesOfType(AbstractSingletonWebService.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WebServiceLoader.init() singleservices = " + this.singleservices));
        }
        for (AbstractSingletonWebService abstractSingletonWebService : this.singleservices) {
            address = this.getAddress(abstractSingletonWebService);
            if (address == null) continue;
            CXFUtils.simpleDeployService(address, abstractSingletonWebService);
            LOG.info((Object)("New singleton WebService '" + address + "' registered."));
        }
        this.multiservices = this.container.getComponentInstancesOfType(AbstractMultiWebService.class);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WebServiceLoader.init() multiservices = " + this.multiservices));
        }
        for (AbstractMultiWebService abstractMultiWebService : this.multiservices) {
            address = this.getAddress(abstractMultiWebService);
            if (address == null) continue;
            CXFUtils.complexDeployServiceMultiInstance(address, abstractMultiWebService, null);
            LOG.info((Object)("New multi-instance WebService '" + address + "' registered."));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("WebServiceLoader.init() customservices = " + this.jcs));
        }
        for (Class clazz : this.jcs) {
            try {
                Object implem = clazz.newInstance();
                String address2 = this.getAddress(implem);
                if (address2 == null) continue;
                CXFUtils.simpleDeployService(address2, implem);
                LOG.info((Object)("New custom WebService '" + address2 + "' registered."));
            }
            catch (Exception e) {
                LOG.error((Object)"Error at implementor.newInstance()", (Throwable)e);
            }
        }
    }

    private String getAddress(Object implementor) {
        String address = "/" + implementor.getClass().getAnnotation(WebService.class).portName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("loadBus() - address = " + address));
            LOG.debug((Object)("loadBus() - implementor = " + implementor));
        }
        return address;
    }

    public void addPlugin(BaseComponentPlugin plugin) {
        if (plugin instanceof WebServiceLoaderPlugin) {
            this.jcs.addAll(((WebServiceLoaderPlugin)plugin).getJcs());
        }
    }
}

