/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.test.mock;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.exoplatform.services.test.mock.CaseInsensitiveMultivaluedMap;
import org.exoplatform.services.test.mock.EnumerationImpl;
import org.exoplatform.services.test.mock.MockHttpSession;
import org.exoplatform.services.test.mock.MockPrincipal;
import org.exoplatform.services.test.mock.MockServletContext;
import org.exoplatform.services.test.mock.MockServletInputStream;

public class MockHttpServletRequest
implements HttpServletRequest {
    private String method;
    private int length;
    private String requestURL;
    private InputStream data;
    private CaseInsensitiveMultivaluedMap<String> headers = new CaseInsensitiveMultivaluedMap();
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();
    private HttpSession session;
    private boolean secure;
    private static final Pattern p = Pattern.compile("http://([^:]+?):([^/]+?)/([^/]+?)/(.*?)");
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private Principal principal;
    private boolean authenticated = true;

    public MockHttpServletRequest(String url, InputStream data, int length, String method, Map<String, List<String>> headers) {
        String queryString;
        this.requestURL = url;
        this.data = data;
        this.length = length;
        this.method = method;
        if (headers != null) {
            this.headers.putAll(headers);
        }
        if ((queryString = this.getQueryString()) != null) {
            this.parameters.putAll(MockHttpServletRequest.parseQueryString(queryString));
        }
        this.session = new MockHttpSession();
    }

    public void reset() {
        this.parameters = new HashMap<String, List<String>>();
        this.attributes = new HashMap<String, Object>();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationImpl(this.attributes.keySet().iterator());
    }

    public String getAuthType() {
        return null;
    }

    public String getCharacterEncoding() {
        return "UTF-8";
    }

    public int getContentLength() {
        return this.length;
    }

    public String getContentType() {
        return this.headers.getFirst("content-type");
    }

    public String getContextPath() {
        Matcher m = p.matcher(this.requestURL);
        if (!m.matches()) {
            throw new RuntimeException("Unable determine context path.");
        }
        return '/' + m.group(3);
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String name) {
        if (this.headers.get(name) != null) {
            return Long.valueOf(this.headers.getFirst(name));
        }
        return -1L;
    }

    public String getHeader(String name) {
        return this.headers.getFirst(name);
    }

    public Enumeration getHeaderNames() {
        return new EnumerationImpl(this.headers.keySet().iterator());
    }

    public Enumeration getHeaders(String name) {
        ArrayList values = (ArrayList)this.headers.get(name);
        if (values.size() > 0) {
            return new EnumerationImpl(values.iterator());
        }
        return new EnumerationImpl(Collections.EMPTY_LIST.iterator());
    }

    public ServletInputStream getInputStream() throws IOException {
        return new MockServletInputStream(this.data);
    }

    public int getIntHeader(String name) {
        if (this.headers.get(name).size() > 0) {
            return Integer.parseInt(this.headers.getFirst(name));
        }
        return -1;
    }

    public String getLocalAddr() {
        return "127.0.0.1";
    }

    public Locale getLocale() {
        return Locale.US;
    }

    public Enumeration getLocales() {
        return null;
    }

    public String getLocalName() {
        return "localhost";
    }

    public int getLocalPort() {
        return 80;
    }

    public String getMethod() {
        return this.method;
    }

    public String getParameter(String name) {
        for (String key : this.parameters.keySet()) {
            ArrayList values;
            if (!key.equalsIgnoreCase(name) || (values = (ArrayList)this.parameters.get(key)) == null) continue;
            return (String)values.get(0);
        }
        return null;
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Enumeration getParameterNames() {
        return new EnumerationImpl(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        ArrayList<String> arr = new ArrayList<String>();
        for (String pname : this.parameters.keySet()) {
            if (!pname.equalsIgnoreCase(name)) continue;
            arr.add(this.parameters.get(name).get(0));
        }
        return arr.toArray(new String[arr.size()]);
    }

    public String getPathInfo() {
        Matcher m = p.matcher(this.requestURL);
        if (!m.matches()) {
            throw new RuntimeException("Unable determine pathInfo.");
        }
        String p = m.group(4);
        int q = p.indexOf(63);
        if (q > 0) {
            p = p.substring(0, q);
        }
        return '/' + p;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public String getQueryString() {
        if (this.requestURL == null) {
            return null;
        }
        int sep = this.requestURL.lastIndexOf(63);
        if (sep == -1) {
            return null;
        }
        return this.requestURL.substring(sep + 1);
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRealPath(String arg0) {
        return null;
    }

    public String getRemoteAddr() {
        return "127.0.0.1";
    }

    public String getRemoteHost() {
        return "localhost";
    }

    public int getRemotePort() {
        return 8080;
    }

    public String getRemoteUser() {
        return this.authenticated ? "root" : null;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return null;
    }

    public String getRequestedSessionId() {
        return "sessionId";
    }

    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath() + this.getPathInfo();
    }

    public StringBuffer getRequestURL() {
        if (this.requestURL == null) {
            return null;
        }
        return new StringBuffer(this.requestURL);
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        Matcher m = p.matcher(this.requestURL);
        if (!m.matches()) {
            throw new RuntimeException("Unable determine server name.");
        }
        return m.group(1);
    }

    public int getServerPort() {
        Matcher m = p.matcher(this.requestURL);
        if (!m.matches()) {
            throw new RuntimeException("Unable determine request URI.");
        }
        return Integer.valueOf(m.group(2));
    }

    public String getServletPath() {
        return "";
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession getSession(boolean b) {
        return this.session;
    }

    public Principal getUserPrincipal() {
        Principal principal = this.authenticated ? (this.principal == null ? (this.principal = new MockPrincipal("root")) : this.principal) : null;
        return principal;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isUserInRole(String role) {
        return "admin".equals(role);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object object) {
        this.attributes.put(name, object);
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
    }

    public void setParameter(String name, String value) {
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(value);
        this.parameters.put(name, arr);
    }

    public static Map<String, List<String>> parseQueryString(String rawQuery) {
        HashMap<String, List<String>> m = new HashMap<String, List<String>>();
        if (rawQuery == null || rawQuery.length() == 0) {
            return m;
        }
        int p = 0;
        int n = 0;
        while (n < rawQuery.length()) {
            List<Object> arr;
            String name;
            String pair;
            n = rawQuery.indexOf(38, p);
            if (n == -1) {
                n = rawQuery.length();
            }
            if ((pair = rawQuery.substring(p, n)).length() == 0) continue;
            String value = "";
            int eq = pair.indexOf(61);
            if (eq == -1) {
                name = pair;
            } else {
                name = pair.substring(0, eq);
                value = pair.substring(eq + 1);
            }
            if (m.get(name) == null) {
                arr = new ArrayList<String>();
                arr.add(value);
                m.put(name, arr);
            } else {
                arr = m.get(name);
                arr.add(value);
            }
            p = n + 1;
        }
        return m;
    }

    public ServletContext getServletContext() {
        return new MockServletContext();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        throw new IllegalStateException("Asynchronous request is not supported");
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        throw new IllegalStateException("Asynchronous request is not supported");
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        throw new IllegalStateException("Request is not in asynchronous mode");
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return this.authenticated;
    }

    public void login(String username, String password) throws ServletException {
        if (this.authenticated) {
            throw new ServletException("Non-null caller identity had already been established");
        }
        this.authenticated = true;
    }

    public void logout() throws ServletException {
        this.authenticated = false;
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        throw new ServletException("Request is not of type multipart/form-data");
    }

    public Part getPart(String name) throws IOException, ServletException {
        throw new ServletException("Request is not of type multipart/form-data");
    }
}

