/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ws.rest.samples;

import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.ContextParam;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.ws.rest.samples.Book;
import org.exoplatform.services.ws.rest.samples.BookStorage;
import org.exoplatform.ws.frameworks.json.transformer.Bean2JsonOutputTransformer;
import org.exoplatform.ws.frameworks.json.transformer.Json2BeanInputTransformer;

public class JsonBookService
implements ResourceContainer {
    private BookStorage books_;
    private static final Log LOGGER = ExoLogger.getLogger((String)"ws.JsonBookService");

    public JsonBookService(BookStorage books) {
        this.books_ = books;
    }

    @HTTPMethod(value="GET")
    @URITemplate(value="/json/{key}/")
    @OutputTransformer(value=Bean2JsonOutputTransformer.class)
    public Response get(@URIParam(value="key") String key) {
        Book book = this.books_.getBook(key);
        if (book == null) {
            return Response.Builder.notFound().build();
        }
        LOGGER.info((Object)("GET: " + book));
        LOGGER.info((Object)("In storage now: " + this.books_.numberOfBooks()));
        return Response.Builder.ok((Object)this.books_.getBook(key)).mediaType("application/json").build();
    }

    @HTTPMethod(value="POST")
    @URITemplate(value="/json/{key}/")
    @InputTransformer(value=Json2BeanInputTransformer.class)
    public Response post(@URIParam(value="key") String key, @ContextParam(value="baseURI") String baseURI, Book book) {
        LOGGER.info((Object)("POST: " + book));
        this.books_.addBook(key, book);
        LOGGER.info((Object)("In storage now: " + this.books_.numberOfBooks()));
        return Response.Builder.created((String)(baseURI + "json" + "/" + key)).build();
    }
}

