/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.cobbler;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyLoader {
    Pattern pattern = Pattern.compile("(\\$\\{)([^}]+)(\\})");

    public void load() throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(System.getProperty("user.dir") + "/user.properties"));
        HashMap<String, String> p = new HashMap<String, String>();
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            String[] parts = line.split("=", 2);
            if (parts.length < 2) {
                System.err.println("Malformed property: " + line);
                continue;
            }
            parts[1] = this.replaceVariables(p, parts[1]);
            p.put(parts[0], parts[1]);
            System.setProperty(parts[0], parts[1]);
        }
    }

    private String replaceVariables(Map<String, String> p, String s) {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        Matcher m = this.pattern.matcher(s);
        while (m.find(i)) {
            String key = m.group(2);
            String value = p.get(key);
            if (value == null) continue;
            int start = m.start();
            int end = m.end();
            sb.append(s.substring(i, start));
            sb.append(value);
            i = end;
        }
        sb.append(s.substring(i));
        return sb.toString();
    }
}

