/*
 * Decompiled with CFR 0.152.
 */
package org.fedorahosted.tennera.jgettext.catalog.util;

import org.fedorahosted.tennera.jgettext.catalog.parse.UnexpectedTokenException;

public class StringUtil {
    private StringUtil() {
    }

    public static String addEscapes(String s) {
        s = s.replace("\r", "\\r");
        s = s.replace("\n", "\\n");
        s = s.replace("\"", "\\\"");
        return s;
    }

    public static String removeEscapes(String s) {
        StringBuilder result = new StringBuilder();
        if (s.length() == 1) {
            if (s.charAt(0) != '\\') {
                return s;
            }
            throw new UnexpectedTokenException("Unexpected token '\\' ", -1);
        }
        char[] chars = s.toCharArray();
        block7: for (int i = 1; i < chars.length; ++i) {
            char prev = chars[i - 1];
            char current = chars[i];
            if (prev == '\\') {
                switch (current) {
                    case '\\': {
                        result.append('\\');
                        chars[i] = 32;
                        continue block7;
                    }
                    case 'r': {
                        result.append('\r');
                        continue block7;
                    }
                    case 'n': {
                        result.append('\n');
                        continue block7;
                    }
                    case 't': {
                        result.append('\t');
                        continue block7;
                    }
                    case '\"': {
                        result.append('\"');
                        continue block7;
                    }
                    default: {
                        throw new UnexpectedTokenException("Invalid escape sequence: " + prev + current, -1);
                    }
                }
            }
            if (i == 1) {
                result.append(prev);
            }
            if (current == '\\') continue;
            result.append(current);
        }
        return result.toString();
    }

    public static String quote(String s) {
        if (s == null) {
            return "null";
        }
        return '\"' + s + '\"';
    }
}

