/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.graph;

import java.util.ArrayList;
import java.util.List;
import org.ff4j.audit.graph.SparklinePoint;

public class SparklineCurve {
    private String title;
    private String lineColor;
    private int nbRecords = 0;
    private long interval = 0L;
    private List<SparklinePoint> listOfPoint = new ArrayList<SparklinePoint>();

    public SparklineCurve(String title) {
        this.title = title;
    }

    public SparklineCurve(String title, long startTime, long endTime, int nbPoints) {
        this(title);
        if (endTime > startTime) {
            this.nbRecords = nbPoints;
            this.interval = (endTime - startTime) / (long)nbPoints;
            for (int slot = 0; slot < nbPoints; ++slot) {
                this.getListOfPoint().add(new SparklinePoint(this.interval * (long)slot, 0.0));
            }
        }
    }

    public void incrCount(int offset) {
        SparklinePoint p = this.getListOfPoint().get(offset);
        p.setY(p.getY() + 1.0);
    }

    public String getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(String lineColor) {
        this.lineColor = lineColor;
    }

    public List<SparklinePoint> getListOfPoint() {
        return this.listOfPoint;
    }

    public void setListOfPoint(List<SparklinePoint> listOfPoint) {
        this.listOfPoint = listOfPoint;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append(" \"title\" : \"" + this.getTitle() + "\", ");
        sb.append(" \"points\" : [");
        boolean first = true;
        for (SparklinePoint p : this.listOfPoint) {
            if (!first) {
                sb.append(",");
            }
            sb.append("{ \"x\" : " + p.getX() + ", \"y\" : " + p.getY() + "}");
            first = false;
        }
        sb.append("] }");
        return sb.toString();
    }

    public int getNbRecords() {
        return this.nbRecords;
    }

    public void setNbRecords(int nbRecords) {
        this.nbRecords = nbRecords;
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }
}

