/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.audit.repository;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.ff4j.audit.Event;
import org.ff4j.audit.EventType;
import org.ff4j.audit.graph.BarChart;
import org.ff4j.audit.graph.BarSeries;
import org.ff4j.audit.graph.PieChart;
import org.ff4j.audit.graph.PieSector;
import org.ff4j.audit.repository.AbstractEventRepository;
import org.ff4j.utils.Util;

public class InMemoryEventRepository
extends AbstractEventRepository {
    private static final int DEFAULT_QUEUE_CAPACITY = 100000;
    private int queueCapacity = 100000;
    private final Map<String, Queue<Event>> mapOfEvents = new ConcurrentHashMap<String, Queue<Event>>();

    public InMemoryEventRepository() {
        this(100000);
    }

    public InMemoryEventRepository(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    @Override
    public boolean saveEvent(Event e) {
        Queue<Event> myQueue;
        if (!this.mapOfEvents.containsKey(e.getFeatureName())) {
            this.mapOfEvents.put(e.getFeatureName(), new ArrayBlockingQueue(this.queueCapacity));
        }
        if ((myQueue = this.mapOfEvents.get(e.getFeatureName())).size() >= this.queueCapacity) {
            myQueue.poll();
        }
        return myQueue.offer(e);
    }

    @Override
    public PieChart getHitsPieChart(long startTime, long endTime) {
        PieChart pieGraph = new PieChart("Total Hit Counts");
        List<String> colors = Util.getColorsGradient(this.mapOfEvents.size());
        ArrayList<String> features = new ArrayList<String>(this.mapOfEvents.keySet());
        for (int idx = 0; idx < this.mapOfEvents.size(); ++idx) {
            Queue<Event> qEvents = this.mapOfEvents.get(features.get(idx));
            int counter = 0;
            for (Event evt : qEvents) {
                if (evt.getTimestamp() <= startTime || evt.getTimestamp() >= endTime || !EventType.FEATURE_CHECK_ON.equals((Object)evt.getType())) continue;
                ++counter;
            }
            pieGraph.getSectors().add(new PieSector((String)features.get(idx), counter, colors.get(idx)));
        }
        return pieGraph;
    }

    @Override
    public PieChart getFeatureHitsPie(String featureId, long startTime, long endTime) {
        List<String> colors = Util.getColorsGradient(4);
        Queue<Event> qEvents = this.mapOfEvents.get(featureId);
        PieChart pieGraph = new PieChart("Hits Count for " + featureId);
        int nbEnable = 0;
        int nbDisable = 0;
        int nbFlip = 0;
        int notFlip = 0;
        if (null != qEvents) {
            for (Event evt : qEvents) {
                if (evt.getTimestamp() <= startTime || evt.getTimestamp() >= endTime) continue;
                switch (evt.getType()) {
                    case FEATURE_CHECK_ON: {
                        ++nbFlip;
                        break;
                    }
                    case FEATURE_CHECK_OFF: {
                        ++notFlip;
                        break;
                    }
                    case ENABLE_FEATURE: {
                        ++nbEnable;
                        break;
                    }
                    case DISABLE_FEATURE: {
                        ++nbDisable;
                    }
                }
            }
        }
        if (nbEnable > 0) {
            pieGraph.getSectors().add(new PieSector(EventType.ENABLE_FEATURE.toString(), nbEnable, colors.get(0)));
        }
        if (nbDisable > 0) {
            pieGraph.getSectors().add(new PieSector(EventType.DISABLE_FEATURE.toString(), nbDisable, colors.get(1)));
        }
        if (nbFlip > 0) {
            pieGraph.getSectors().add(new PieSector(EventType.FEATURE_CHECK_ON.toString(), nbFlip, colors.get(2)));
        }
        if (notFlip > 0) {
            pieGraph.getSectors().add(new PieSector(EventType.FEATURE_CHECK_OFF.toString(), notFlip, colors.get(3)));
        }
        return pieGraph;
    }

    @Override
    public BarChart getHitsBarChart(Set<String> featNameSet, long startTime, long endTime, int nbslot) {
        long slotWitdh = (endTime - startTime) / (long)nbslot;
        SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < nbslot; ++i) {
            labels.add(sdf.format(new Date(startTime + slotWitdh * (long)i)));
        }
        BarChart barChart = new BarChart("HitCounts Distribution", labels, new ArrayList<String>(featNameSet));
        for (String name : featNameSet) {
            Queue<Event> myQueue = this.mapOfEvents.get(name);
            BarSeries currentSeries = barChart.getSeries().get(name);
            if (myQueue == null) continue;
            for (Event evt : myQueue) {
                long t = evt.getTimestamp();
                if (startTime >= t || t >= endTime || !EventType.FEATURE_CHECK_ON.equals((Object)evt.getType())) continue;
                currentSeries.incrCount((int)((t - startTime) / slotWitdh));
            }
        }
        return barChart;
    }

    @Override
    public int getTotalEventCount() {
        Set<String> queues = this.mapOfEvents.keySet();
        int total = 0;
        for (String queue : queues) {
            total += this.mapOfEvents.get(queue).size();
        }
        return total;
    }

    @Override
    public Set<String> getFeatureNames() {
        return this.mapOfEvents.keySet();
    }
}

