/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.ff4j.property.AbstractProperty;
import org.ff4j.property.Property;

public class PropertyFactory {
    private PropertyFactory() {
    }

    public static AbstractProperty<?> createProperty(String pName, String pType, String pValue) {
        return PropertyFactory.createProperty(pName, pType, pValue, null, null);
    }

    public static AbstractProperty<?> createProperty(String pName, String pType, String pValue, String desc, String fixedValues) {
        List<String> listOfFixedValue;
        if (pName == null) {
            throw new IllegalArgumentException("pName (param#0) is expected to create property");
        }
        if (pType == null) {
            throw new IllegalArgumentException("Type (param#1) is expected to create property");
        }
        AbstractProperty ap = new Property(pName, pValue);
        try {
            Constructor<?> constr = Class.forName(pType).getConstructor(String.class, String.class);
            ap = (AbstractProperty)constr.newInstance(pName, pValue);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate '" + pType + "' check default constructor : " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot instantiate '" + pType + "' check constructor visibility : " + e.getMessage(), e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot instantiate '" + pType + "' class not found : " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot instantiate '" + pType + "' error within constructor (InvocationTargetException)", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Cannot instantiate '" + pType + "' constructor not found :" + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Cannot instantiate '" + pType + "' check constructor visibility :" + e.getMessage(), e);
        }
        if (desc != null && !"".equals(desc)) {
            ap.setDescription(desc);
        }
        if (fixedValues != null && !"".equals(fixedValues) && (listOfFixedValue = Arrays.asList(fixedValues.split(","))) != null) {
            for (String v : listOfFixedValue) {
                ap.add2FixedValueFromString(v.trim());
            }
            if (ap.getFixedValues() != null && !ap.getFixedValues().contains(ap.getValue())) {
                throw new IllegalArgumentException("Cannot create property <" + ap.getName() + "> invalid value <" + ap.getValue() + "> expected one of " + ap.getFixedValues());
            }
        }
        return ap;
    }
}

