/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.property.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.PropertyAlreadyExistException;
import org.ff4j.exception.PropertyNotFoundException;
import org.ff4j.property.AbstractProperty;
import org.ff4j.property.store.AbstractPropertyStore;
import org.ff4j.property.store.JdbcPropertyMapper;
import org.ff4j.store.JdbcStoreConstants;
import org.ff4j.utils.Util;

public class JdbcPropertyStore
extends AbstractPropertyStore
implements JdbcStoreConstants {
    private DataSource dataSource;
    private JdbcPropertyMapper JDBC_MAPPER = new JdbcPropertyMapper();

    public JdbcPropertyStore(DataSource jdbcDS) {
        this.dataSource = jdbcDS;
    }

    public JdbcPropertyStore(DataSource jdbcDS, String xmlConfFile) {
        this(jdbcDS);
        this.importPropertiesFromXmlFile(xmlConfFile);
    }

    @Override
    public boolean exist(String name) {
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            Util.assertHasLength(name);
            ps = null;
            rs = null;
            ps = this.buildStatement("SELECT COUNT(*) FROM FF4J_PROPERTIES WHERE PROPERTY_ID = ?", name);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            boolean bl = 1 == rs.getInt(1);
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return bl;
        }
        try {
            boolean bl = false;
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return bl;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot check feature existence, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
    }

    @Override
    public <T> void create(AbstractProperty<T> ap) {
        if (ap == null) {
            throw new IllegalArgumentException("Property cannot be null nor empty");
        }
        if (this.exist(ap.getName())) {
            throw new PropertyAlreadyExistException(ap.getName());
        }
        PreparedStatement ps = null;
        try {
            Connection sqlConn = this.getDataSource().getConnection();
            ps = sqlConn.prepareStatement("INSERT INTO FF4J_PROPERTIES(PROPERTY_ID, CLAZZ, CURRENTVALUE, DESCRIPTION, FIXEDVALUES) VALUES(?, ?, ?, ?, ?)");
            ps.setString(1, ap.getName());
            ps.setString(2, ap.getType());
            ps.setString(3, ap.asString());
            ps.setString(4, ap.getDescription());
            if (ap.getFixedValues() != null && ap.getFixedValues().size() > 0) {
                String fixedValues = ap.getFixedValues().toString();
                ps.setString(5, fixedValues.substring(1, fixedValues.length() - 1));
            } else {
                ps.setString(5, null);
            }
            ps.executeUpdate();
            this.closeStatement(ps);
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot update properties database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                this.closeStatement(ps);
                throw throwable;
            }
        }
    }

    @Override
    public AbstractProperty<?> read(String name) {
        ResultSet rs;
        PreparedStatement ps;
        block5: {
            ps = null;
            rs = null;
            Util.assertHasLength(name);
            ps = this.buildStatement("SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,DESCRIPTION,FIXEDVALUES FROM FF4J_PROPERTIES WHERE PROPERTY_ID = ?", name);
            rs = ps.executeQuery();
            if (!rs.next()) break block5;
            AbstractProperty<?> abstractProperty = this.JDBC_MAPPER.map(rs);
            this.closeResultSet(rs);
            this.closeStatement(ps);
            return abstractProperty;
        }
        try {
            try {
                throw new PropertyNotFoundException(name);
            }
            catch (SQLException sqlEX) {
                throw new FeatureAccessException("Cannot check property existence, error related to database", sqlEX);
            }
        }
        catch (Throwable throwable) {
            this.closeResultSet(rs);
            this.closeStatement(ps);
            throw throwable;
        }
    }

    @Override
    public void update(String name, String newValue) {
        Util.assertHasLength(name);
        if (!this.exist(name)) {
            throw new PropertyNotFoundException(name);
        }
        AbstractProperty<?> current = this.read(name);
        current.setValueFromString(newValue);
        PreparedStatement ps = null;
        try {
            ps = this.buildStatement("UPDATE FF4J_PROPERTIES SET CURRENTVALUE = ? WHERE PROPERTY_ID = ?", newValue, name);
            ps.executeUpdate();
            this.closeStatement(ps);
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot update property database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                this.closeStatement(ps);
                throw throwable;
            }
        }
    }

    @Override
    public <T> void update(AbstractProperty<T> prop) {
        if (prop == null || prop.getName() == null) {
            throw new IllegalArgumentException("Cannot update property, please provide property name");
        }
        this.delete(prop.getName());
        this.create(prop);
    }

    @Override
    public void delete(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Property identifier (param#0) cannot be null nor empty");
        }
        if (!this.exist(name)) {
            throw new PropertyNotFoundException(name);
        }
        PreparedStatement ps = null;
        try {
            ps = this.buildStatement("DELETE FROM FF4J_PROPERTIES WHERE PROPERTY_ID = ?", name);
            ps.executeUpdate();
            this.closeStatement(ps);
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot delete property database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                this.closeStatement(ps);
                throw throwable;
            }
        }
    }

    @Override
    public Map<String, AbstractProperty<?>> readAllProperties() {
        LinkedHashMap properties = new LinkedHashMap();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.buildStatement("SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,DESCRIPTION,FIXEDVALUES FROM FF4J_PROPERTIES WHERE PROPERTY_ID = ?", new String[0]);
            rs = ps.executeQuery();
            while (rs.next()) {
                AbstractProperty<?> ap = this.JDBC_MAPPER.map(rs);
                properties.put(ap.getName(), ap);
            }
            ps.executeUpdate();
            this.closeResultSet(rs);
            this.closeStatement(ps);
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot read properties within database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                this.closeResultSet(rs);
                this.closeStatement(ps);
                throw throwable;
            }
        }
        return properties;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public PreparedStatement buildStatement(String query, String ... params) throws SQLException {
        Connection sqlConn = this.getDataSource().getConnection();
        PreparedStatement ps = sqlConn.prepareStatement(query);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                ps.setString(i + 1, params[i]);
            }
        }
        return ps;
    }

    private void closeResultSet(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("An error occur when closing resultset", e);
        }
    }

    private void closeStatement(PreparedStatement ps) {
        try {
            if (ps != null && !ps.isClosed()) {
                if (ps.getConnection() != null && !ps.getConnection().isClosed()) {
                    ps.getConnection().close();
                }
                ps.close();
            }
        }
        catch (SQLException e) {
            throw new FeatureAccessException("An error occur when closing statement", e);
        }
    }
}

