/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.ff4j.core.Feature;
import org.ff4j.core.FlippingStrategy;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.store.JdbcStoreConstants;
import org.ff4j.utils.ParameterUtils;

public class JdbcFeatureMapper
implements JdbcStoreConstants {
    public Feature mapFeature(ResultSet rs) throws SQLException {
        Feature f = null;
        boolean enabled = rs.getInt("ENABLE") > 0;
        String featUid = rs.getString("FEAT_UID");
        f = new Feature(featUid, enabled, rs.getString("DESCRIPTION"), rs.getString("GROUPNAME"));
        String strategy = rs.getString("STRATEGY");
        if (strategy != null && !"".equals(strategy)) {
            try {
                FlippingStrategy flipStrategy = (FlippingStrategy)Class.forName(strategy).newInstance();
                flipStrategy.init(featUid, ParameterUtils.toMap(rs.getString("EXPRESSION")));
                f.setFlippingStrategy(flipStrategy);
            }
            catch (InstantiationException ie) {
                throw new FeatureAccessException("Cannot instantiate Strategy, no default constructor available", ie);
            }
            catch (IllegalAccessException iae) {
                throw new FeatureAccessException("Cannot instantiate Strategy, no visible constructor", iae);
            }
            catch (ClassNotFoundException e) {
                throw new FeatureAccessException("Cannot instantiate Strategy, classNotFound", e);
            }
        }
        return f;
    }
}

