/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.ff4j.core.Feature;
import org.ff4j.exception.FeatureAccessException;
import org.ff4j.exception.FeatureAlreadyExistException;
import org.ff4j.exception.FeatureNotFoundException;
import org.ff4j.exception.GroupNotFoundException;
import org.ff4j.property.AbstractProperty;
import org.ff4j.property.store.JdbcPropertyMapper;
import org.ff4j.store.AbstractFeatureStore;
import org.ff4j.store.JdbcFeatureMapper;
import org.ff4j.store.JdbcStoreConstants;
import org.ff4j.utils.JdbcUtils;
import org.ff4j.utils.ParameterUtils;
import org.ff4j.utils.Util;

public class JdbcFeatureStore
extends AbstractFeatureStore
implements JdbcStoreConstants {
    private DataSource dataSource;
    private JdbcPropertyMapper JDBC_PROPERTY_MAPPER = new JdbcPropertyMapper();
    private JdbcFeatureMapper JDBC_FEATURE_MAPPER = new JdbcFeatureMapper();

    public JdbcFeatureStore() {
    }

    public JdbcFeatureStore(DataSource jdbcDS) {
        this.dataSource = jdbcDS;
    }

    public JdbcFeatureStore(DataSource jdbcDS, String xmlConfFile) {
        this(jdbcDS);
        this.importFeaturesFromXmlFile(xmlConfFile);
    }

    @Override
    public void enable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.update("UPDATE FF4J_FEATURES SET ENABLE = 1 WHERE FEAT_UID = ?", uid);
    }

    @Override
    public void disable(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.update("UPDATE FF4J_FEATURES SET ENABLE = 0 WHERE FEAT_UID = ?", uid);
    }

    @Override
    public boolean exist(String uid) {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        Connection sqlConn;
        block6: {
            if (uid == null || uid.isEmpty()) {
                throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
            }
            sqlConn = null;
            ps = null;
            rs = null;
            sqlConn = this.getDataSource().getConnection();
            ps = sqlConn.prepareStatement("SELECT COUNT(FEAT_UID) FROM FF4J_FEATURES WHERE FEAT_UID = ?");
            ps.setString(1, uid);
            rs = ps.executeQuery();
            if (!rs.next()) break block6;
            boolean bl2 = 1 == rs.getInt(1);
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeConnection(sqlConn);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot check feature existence, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return bl;
    }

    @Override
    public Feature read(String uid) {
        Feature feature;
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            ps = sqlConn.prepareStatement("SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES WHERE FEAT_UID = ?");
            ps.setString(1, uid);
            rs = ps.executeQuery();
            Feature f = null;
            if (!rs.next()) {
                throw new FeatureNotFoundException(uid);
            }
            f = this.JDBC_FEATURE_MAPPER.mapFeature(rs);
            ps = sqlConn.prepareStatement("SELECT ROLE_NAME FROM FF4J_ROLES WHERE FEAT_UID = ?");
            ps.setString(1, uid);
            rs = ps.executeQuery();
            while (rs.next()) {
                f.getPermissions().add(rs.getString("ROLE_NAME"));
            }
            ps = sqlConn.prepareStatement("SELECT PROPERTY_ID,CLAZZ,CURRENTVALUE,DESCRIPTION,FIXEDVALUES,FEAT_UID FROM FF4J_CUSTOM_PROPERTIES WHERE FEAT_UID = ?");
            ps.setString(1, uid);
            rs = ps.executeQuery();
            while (rs.next()) {
                AbstractProperty<?> ap = this.JDBC_PROPERTY_MAPPER.map(rs);
                f.getCustomProperties().put(ap.getName(), ap);
            }
            feature = f;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot check feature existence, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return feature;
    }

    @Override
    public void create(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        if (this.exist(fp.getUid())) {
            throw new FeatureAlreadyExistException(fp.getUid());
        }
        Connection sqlConn = null;
        PreparedStatement ps = null;
        try {
            sqlConn = this.getDataSource().getConnection();
            sqlConn.setAutoCommit(false);
            ps = sqlConn.prepareStatement("INSERT INTO FF4J_FEATURES(FEAT_UID, ENABLE, DESCRIPTION, STRATEGY,EXPRESSION, GROUPNAME) VALUES(?, ?, ?, ?, ?, ?)");
            ps.setString(1, fp.getUid());
            ps.setInt(2, fp.isEnable() ? 1 : 0);
            ps.setString(3, fp.getDescription());
            String strategyColumn = null;
            String expressionColumn = null;
            if (fp.getFlippingStrategy() != null) {
                strategyColumn = fp.getFlippingStrategy().getClass().getCanonicalName();
                expressionColumn = ParameterUtils.fromMap(fp.getFlippingStrategy().getInitParams());
            }
            ps.setString(4, strategyColumn);
            ps.setString(5, expressionColumn);
            ps.setString(6, fp.getGroup());
            ps.executeUpdate();
            if (fp.getPermissions() != null) {
                for (String string : fp.getPermissions()) {
                    ps = sqlConn.prepareStatement("INSERT INTO FF4J_ROLES(FEAT_UID, ROLE_NAME) VALUES (?,?)");
                    ps.setString(1, fp.getUid());
                    ps.setString(2, string);
                    ps.executeUpdate();
                }
            }
            if (fp.getCustomProperties() != null && !fp.getCustomProperties().isEmpty()) {
                for (AbstractProperty abstractProperty : fp.getCustomProperties().values()) {
                    ps = sqlConn.prepareStatement("INSERT INTO FF4J_CUSTOM_PROPERTIES(PROPERTY_ID, CLAZZ, CURRENTVALUE, FIXEDVALUES, FEAT_UID) VALUES(?, ?, ?, ?, ?)");
                    ps.setString(1, abstractProperty.getName());
                    ps.setString(2, abstractProperty.getType());
                    ps.setString(3, abstractProperty.asString());
                    if (abstractProperty.getFixedValues() != null && abstractProperty.getFixedValues().size() > 0) {
                        String fixedValues = abstractProperty.getFixedValues().toString();
                        ps.setString(4, fixedValues.substring(1, fixedValues.length() - 1));
                    } else {
                        ps.setString(4, null);
                    }
                    ps.setString(5, fp.getUid());
                    ps.executeUpdate();
                }
            }
            sqlConn.commit();
        }
        catch (SQLException sqlEX) {
            try {
                JdbcUtils.rollback(sqlConn);
                throw new FeatureAccessException("Cannot update features database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
    }

    @Override
    public void delete(String uid) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier (param#0) cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        Connection sqlConn = null;
        PreparedStatement ps = null;
        try {
            Feature fp = this.read(uid);
            sqlConn = this.getDataSource().getConnection();
            sqlConn.setAutoCommit(false);
            if (fp.getCustomProperties() != null && !fp.getCustomProperties().isEmpty()) {
                for (String property : fp.getCustomProperties().keySet()) {
                    ps = sqlConn.prepareStatement("DELETE FROM FF4J_CUSTOM_PROPERTIES WHERE PROPERTY_ID = ? AND FEAT_UID = ?");
                    ps.setString(1, property);
                    ps.setString(2, fp.getUid());
                    ps.executeUpdate();
                }
            }
            if (fp.getPermissions() != null) {
                for (String role : fp.getPermissions()) {
                    ps = sqlConn.prepareStatement("DELETE FROM FF4J_ROLES WHERE FEAT_UID = ? AND ROLE_NAME = ?");
                    ps.setString(1, fp.getUid());
                    ps.setString(2, role);
                    ps.executeUpdate();
                }
            }
            ps = sqlConn.prepareStatement("DELETE FROM FF4J_FEATURES WHERE FEAT_UID = ?");
            ps.setString(1, fp.getUid());
            ps.executeUpdate();
            sqlConn.commit();
        }
        catch (SQLException sqlEX) {
            try {
                JdbcUtils.rollback(sqlConn);
                throw new FeatureAccessException("Cannot update features database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
    }

    @Override
    public void grantRoleOnFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.update("INSERT INTO FF4J_ROLES(FEAT_UID, ROLE_NAME) VALUES (?,?)", uid, roleName);
    }

    @Override
    public void removeRoleFromFeature(String uid, String roleName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (roleName == null || roleName.isEmpty()) {
            throw new IllegalArgumentException("roleName cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.update("DELETE FROM FF4J_ROLES WHERE FEAT_UID = ? AND ROLE_NAME = ?", uid, roleName);
    }

    @Override
    public Map<String, Feature> readAll() {
        Object uid;
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement("SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES");
            rs = ps.executeQuery();
            while (rs.next()) {
                Feature f = this.JDBC_FEATURE_MAPPER.mapFeature(rs);
                mapFP.put(f.getUid(), f);
            }
            rs = ps.getConnection().prepareStatement("SELECT FEAT_UID,ROLE_NAME FROM FF4J_ROLES").executeQuery();
            while (rs.next()) {
                uid = rs.getString("FEAT_UID");
                ((Feature)mapFP.get(uid)).getPermissions().add(rs.getString("ROLE_NAME"));
            }
            uid = mapFP;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot check feature existence, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return uid;
    }

    @Override
    public Set<String> readAllGroups() {
        Object groupName;
        HashSet<Object> setOFGroup = new HashSet<Object>();
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement("SELECT DISTINCT(GROUPNAME) FROM FF4J_FEATURES");
            rs = ps.executeQuery();
            while (rs.next()) {
                groupName = rs.getString("GROUPNAME");
                if (groupName == null || "".equals(groupName)) continue;
                setOFGroup.add(groupName);
            }
            groupName = setOFGroup;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot list groups, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return groupName;
    }

    @Override
    public void update(Feature fp) {
        if (fp == null) {
            throw new IllegalArgumentException("Feature cannot be null nor empty");
        }
        Feature fpExist = this.read(fp.getUid());
        String enable = "0";
        if (fp.isEnable()) {
            enable = "1";
        }
        String fStrategy = null;
        String fExpression = null;
        if (fp.getFlippingStrategy() != null) {
            fStrategy = fp.getFlippingStrategy().getClass().getCanonicalName();
            fExpression = ParameterUtils.fromMap(fp.getFlippingStrategy().getInitParams());
        }
        this.update("UPDATE FF4J_FEATURES SET ENABLE=?,DESCRIPTION=?,STRATEGY=?,EXPRESSION=?,GROUPNAME=? WHERE FEAT_UID = ?", enable, fp.getDescription(), fStrategy, fExpression, fp.getGroup(), fp.getUid());
        HashSet<String> toBeDeleted = new HashSet<String>();
        toBeDeleted.addAll(fpExist.getPermissions());
        toBeDeleted.removeAll(fp.getPermissions());
        for (String string : toBeDeleted) {
            this.removeRoleFromFeature(fpExist.getUid(), string);
        }
        HashSet<String> toBeAdded = new HashSet<String>();
        toBeAdded.addAll(fp.getPermissions());
        toBeAdded.removeAll(fpExist.getPermissions());
        for (String addee : toBeAdded) {
            this.grantRoleOnFeature(fpExist.getUid(), addee);
        }
        if (fpExist.getCustomProperties() != null && !fpExist.getCustomProperties().isEmpty()) {
            Connection connection;
            Connection connection2 = null;
            PreparedStatement ps = null;
            try {
                connection = this.dataSource.getConnection();
                ps = connection.prepareStatement("DELETE FROM FF4J_CUSTOM_PROPERTIES WHERE FEAT_UID = ?");
                ps.setString(1, fpExist.getUid());
                ps.executeUpdate();
            }
            catch (SQLException sqlEX) {
                try {
                    throw new FeatureAccessException("Cannot check feature existence, error related to database", sqlEX);
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeStatement(ps);
                    JdbcUtils.closeConnection(connection2);
                    throw throwable;
                }
            }
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeConnection(connection);
        }
        if (fp.getCustomProperties() != null && !fp.getCustomProperties().isEmpty()) {
            this.createCustomProperties(fp.getUid(), fp.getCustomProperties().values());
        }
    }

    private void createCustomProperties(String uid, Collection<AbstractProperty<?>> props) {
        Util.assertNotNull(uid);
        if (props == null | props.isEmpty()) {
            return;
        }
        Connection sqlConn = null;
        PreparedStatement ps = null;
        try {
            sqlConn = this.dataSource.getConnection();
            sqlConn.setAutoCommit(false);
            for (AbstractProperty<?> pp : props) {
                ps = sqlConn.prepareStatement("INSERT INTO FF4J_CUSTOM_PROPERTIES(PROPERTY_ID, CLAZZ, CURRENTVALUE, FIXEDVALUES, FEAT_UID) VALUES(?, ?, ?, ?, ?)");
                ps.setString(1, pp.getName());
                ps.setString(2, pp.getType());
                ps.setString(3, pp.asString());
                if (pp.getFixedValues() != null && pp.getFixedValues().size() > 0) {
                    String fixedValues = pp.getFixedValues().toString();
                    ps.setString(4, fixedValues.substring(1, fixedValues.length() - 1));
                } else {
                    ps.setString(4, null);
                }
                ps.setString(5, uid);
                ps.executeUpdate();
            }
            sqlConn.commit();
        }
        catch (SQLException sqlEX) {
            throw new FeatureAccessException("Cannot check feature existence, error related to database", sqlEX);
        }
        finally {
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeConnection(sqlConn);
        }
    }

    @Override
    public boolean existGroup(String groupName) {
        boolean bl;
        ResultSet rs;
        PreparedStatement ps;
        Connection sqlConn;
        block6: {
            if (groupName == null || groupName.isEmpty()) {
                throw new IllegalArgumentException("Groupname cannot be null nor empty");
            }
            sqlConn = null;
            ps = null;
            rs = null;
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement("SELECT COUNT(*) FROM FF4J_FEATURES WHERE GROUPNAME = ?");
            ps.setString(1, groupName);
            rs = ps.executeQuery();
            if (!rs.next()) break block6;
            boolean bl2 = rs.getInt(1) > 0;
            JdbcUtils.closeResultSet(rs);
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeConnection(sqlConn);
            return bl2;
        }
        try {
            bl = false;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot check feature existence, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return bl;
    }

    @Override
    public void enableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        this.update("UPDATE FF4J_FEATURES SET ENABLE = 1 WHERE GROUPNAME = ?", groupName);
    }

    @Override
    public void disableGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        this.update("UPDATE FF4J_FEATURES SET ENABLE = 0 WHERE GROUPNAME = ?", groupName);
    }

    @Override
    public Map<String, Feature> readGroup(String groupName) {
        Object uid;
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        LinkedHashMap<String, Feature> mapFP = new LinkedHashMap<String, Feature>();
        Connection sqlConn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            sqlConn = this.dataSource.getConnection();
            ps = sqlConn.prepareStatement("SELECT FEAT_UID,ENABLE,DESCRIPTION,STRATEGY,EXPRESSION,GROUPNAME FROM FF4J_FEATURES WHERE GROUPNAME = ?");
            ps.setString(1, groupName);
            rs = ps.executeQuery();
            while (rs.next()) {
                Feature f = this.JDBC_FEATURE_MAPPER.mapFeature(rs);
                mapFP.put(f.getUid(), f);
            }
            rs = ps.getConnection().prepareStatement("SELECT FEAT_UID,ROLE_NAME FROM FF4J_ROLES").executeQuery();
            while (rs.next()) {
                uid = rs.getString("FEAT_UID");
                if (!mapFP.containsKey(uid)) continue;
                ((Feature)mapFP.get(uid)).getPermissions().add(rs.getString("ROLE_NAME"));
            }
            uid = mapFP;
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot check feature existence, error related to database", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeResultSet(rs);
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConn);
                throw throwable;
            }
        }
        JdbcUtils.closeResultSet(rs);
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConn);
        return uid;
    }

    @Override
    public void addToGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        this.update("UPDATE FF4J_FEATURES SET GROUPNAME = ? WHERE FEAT_UID = ?", groupName, uid);
    }

    @Override
    public void removeFromGroup(String uid, String groupName) {
        if (uid == null || uid.isEmpty()) {
            throw new IllegalArgumentException("Feature identifier cannot be null nor empty");
        }
        if (groupName == null || groupName.isEmpty()) {
            throw new IllegalArgumentException("Groupname cannot be null nor empty");
        }
        if (!this.exist(uid)) {
            throw new FeatureNotFoundException(uid);
        }
        if (!this.existGroup(groupName)) {
            throw new GroupNotFoundException(groupName);
        }
        Feature feat = this.read(uid);
        if (feat.getGroup() != null && !feat.getGroup().equals(groupName)) {
            throw new IllegalArgumentException("'" + uid + "' is not in group '" + groupName + "'");
        }
        this.update("UPDATE FF4J_FEATURES SET GROUPNAME = ? WHERE FEAT_UID = ?", "", uid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"type\":\"" + this.getClass().getCanonicalName() + "\"");
        sb.append("\"datasource\":\"" + this.dataSource.getClass() + "\"");
        sb.append(",\"cached\":" + this.isCached());
        if (this.isCached()) {
            sb.append(",\"cacheProvider\":\"" + this.getCacheProvider() + "\"");
            sb.append(",\"cacheStore\":\"" + this.getCachedTargetStore() + "\"");
        }
        Set<String> myFeatures = this.readAll().keySet();
        sb.append(",\"numberOfFeatures\":" + myFeatures.size());
        sb.append(",\"features\":[");
        boolean first = true;
        for (String myFeature : myFeatures) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myFeature + "\"");
        }
        Set<String> myGroups = this.readAllGroups();
        sb.append("],\"numberOfGroups\":" + myGroups.size());
        sb.append(",\"groups\":[");
        first = true;
        for (String myGroup : myGroups) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append("\"" + myGroup + "\"");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean isCached() {
        return false;
    }

    @Override
    public String getCacheProvider() {
        return null;
    }

    @Override
    public String getCachedTargetStore() {
        return null;
    }

    private PreparedStatement buildStatement(Connection sqlConn, String query, String ... params) throws SQLException {
        PreparedStatement ps = sqlConn.prepareStatement(query);
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                ps.setString(i + 1, params[i]);
            }
        }
        return ps;
    }

    private void update(String query, String ... params) {
        Connection sqlConnection = null;
        PreparedStatement ps = null;
        try {
            sqlConnection = this.dataSource.getConnection();
            ps = this.buildStatement(sqlConnection, query, params);
            ps.executeUpdate();
        }
        catch (SQLException sqlEX) {
            try {
                throw new FeatureAccessException("Cannot update features database, SQL ERROR", sqlEX);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(ps);
                JdbcUtils.closeConnection(sqlConnection);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(ps);
        JdbcUtils.closeConnection(sqlConnection);
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            throw new IllegalStateException("DataSource has not been initialized");
        }
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

