/*
 * Decompiled with CFR 0.152.
 */
package org.ff4j.strategy.el;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ff4j.strategy.el.ExpressionOperator;

public class ExpressionNode {
    private ExpressionOperator operator;
    private String value;
    private final List<ExpressionNode> subNodes = new ArrayList<ExpressionNode>();

    public ExpressionNode(String sheetValue) {
        this.value = sheetValue;
    }

    public ExpressionNode(ExpressionOperator ops) {
        this.operator = ops;
    }

    public boolean evalue(Map<String, Boolean> stateMap) {
        if (this.value != null && !this.value.isEmpty()) {
            return this.evaluateValue(stateMap);
        }
        if (ExpressionOperator.NOT.equals((Object)this.operator)) {
            return this.evaluateOperatorNot(stateMap);
        }
        if (ExpressionOperator.AND.equals((Object)this.operator)) {
            return this.evaluateOperatorAnd(stateMap);
        }
        return this.evaluateOperatorOr(stateMap);
    }

    private boolean evaluateValue(Map<String, Boolean> stateMap) {
        if (stateMap.containsKey(this.value)) {
            return stateMap.get(this.value);
        }
        return false;
    }

    private boolean evaluateOperatorNot(Map<String, Boolean> stateMap) {
        return !this.subNodes.get(0).evalue(stateMap);
    }

    private boolean evaluateOperatorAnd(Map<String, Boolean> stateMap) {
        boolean status = true;
        for (int idx = 0; status && idx < this.subNodes.size(); ++idx) {
            status = status && this.subNodes.get(idx).evalue(stateMap);
        }
        return status;
    }

    private boolean evaluateOperatorOr(Map<String, Boolean> stateMap) {
        boolean status = true;
        status = false;
        for (int idx = 0; !status && idx < this.subNodes.size(); ++idx) {
            status = this.subNodes.get(idx).evalue(stateMap);
        }
        return status;
    }

    public String toString() {
        if (this.value != null && !this.value.isEmpty()) {
            return this.value;
        }
        StringBuilder strBuilder = new StringBuilder("");
        boolean first = true;
        if (ExpressionOperator.NOT.equals((Object)this.operator)) {
            strBuilder.append("!");
        }
        first = true;
        for (ExpressionNode subnode : this.subNodes) {
            if (!first) {
                strBuilder.append(" " + (Object)((Object)this.operator) + " ");
            }
            if (subnode.getValue() == null || subnode.getValue().isEmpty()) {
                strBuilder.append("(" + subnode.toString() + ")");
            } else {
                strBuilder.append(subnode.toString());
            }
            first = false;
        }
        return strBuilder.toString();
    }

    public ExpressionOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ExpressionOperator operator) {
        this.operator = operator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<ExpressionNode> getSubNodes() {
        return this.subNodes;
    }
}

