/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.runtime.InjectedPlanItemInstanceBuilderImpl;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.Case;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public class CreateInjectedPlanItemInstanceCmd
implements Command<PlanItemInstance> {
    protected final InjectedPlanItemInstanceBuilderImpl planItemInstanceBuilder;

    public CreateInjectedPlanItemInstanceCmd(InjectedPlanItemInstanceBuilderImpl planItemInstanceBuilder) {
        this.planItemInstanceBuilder = planItemInstanceBuilder;
    }

    public PlanItemInstance execute(CommandContext commandContext) {
        String runningCaseDefinitionId;
        String tenantId;
        String caseInstanceId;
        Case caseModel = CaseDefinitionUtil.getCase(this.planItemInstanceBuilder.getCaseDefinitionId());
        if (caseModel == null) {
            throw new FlowableIllegalArgumentException("Could not find case model with case definition id " + this.planItemInstanceBuilder.getCaseDefinitionId());
        }
        CaseElement caseElement = (CaseElement)caseModel.getAllCaseElements().get(this.planItemInstanceBuilder.getElementId());
        if (caseElement == null) {
            throw new FlowableIllegalArgumentException("Could not find case element with id " + this.planItemInstanceBuilder.getElementId());
        }
        if (!(caseElement instanceof PlanItem)) {
            throw new FlowableIllegalArgumentException("The case element needs to be a plan item, but is a " + caseElement.getClass().getName());
        }
        PlanItemInstanceEntity stagePlanItemInstance = null;
        if (this.planItemInstanceBuilder.injectInStage()) {
            stagePlanItemInstance = this.getStageInstanceEntity(commandContext);
            caseInstanceId = stagePlanItemInstance.getCaseInstanceId();
            tenantId = stagePlanItemInstance.getTenantId();
            runningCaseDefinitionId = stagePlanItemInstance.getCaseDefinitionId();
        } else if (this.planItemInstanceBuilder.injectInCase()) {
            CaseInstanceEntity caseInstance = this.getCaseInstanceEntity(commandContext);
            caseInstanceId = caseInstance.getId();
            tenantId = caseInstance.getTenantId();
            runningCaseDefinitionId = caseInstance.getCaseDefinitionId();
        } else {
            throw new FlowableIllegalArgumentException("A dynamically created plan item can only be injected into a running stage instance or case instance.");
        }
        PlanItemInstanceEntity planItemInstanceEntity = CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).createPlanItemInstanceEntityBuilder().caseDefinitionId(runningCaseDefinitionId).derivedCaseDefinitionId(this.planItemInstanceBuilder.getCaseDefinitionId()).planItem((PlanItem)caseElement).name(this.planItemInstanceBuilder.getName()).caseInstanceId(caseInstanceId).stagePlanItemInstance((PlanItemInstance)stagePlanItemInstance).tenantId(tenantId).addToParent(true).create();
        CommandContextUtil.getAgenda(commandContext).planCreatePlanItemInstanceOperation(planItemInstanceEntity);
        CommandContextUtil.getAgenda(commandContext).planEvaluateToActivatePlanItemInstanceOperation(planItemInstanceEntity);
        return planItemInstanceEntity;
    }

    protected PlanItemInstanceEntity getStageInstanceEntity(CommandContext commandContext) {
        PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)CommandContextUtil.getPlanItemInstanceEntityManager(commandContext).findById(this.planItemInstanceBuilder.getStagePlanItemInstanceId());
        if (planItemInstanceEntity == null) {
            throw new FlowableIllegalArgumentException("The stage plan item instance id " + this.planItemInstanceBuilder.getStagePlanItemInstanceId() + " could not be found or is no longer active.");
        }
        if (!planItemInstanceEntity.isStage()) {
            throw new FlowableIllegalArgumentException("A dynamically created plan item can only be injected into a running stage plan item.");
        }
        return planItemInstanceEntity;
    }

    protected CaseInstanceEntity getCaseInstanceEntity(CommandContext commandContext) {
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(commandContext).findById(this.planItemInstanceBuilder.getCaseInstanceId());
        if (caseInstanceEntity == null) {
            throw new FlowableIllegalArgumentException("The case instance with id " + this.planItemInstanceBuilder.getCaseInstanceId() + " could not be found or is no longer an ative case instance.");
        }
        return caseInstanceEntity;
    }
}

