/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.history;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.flowable.cmmn.api.history.HistoricCaseInstance;
import org.flowable.cmmn.api.history.HistoricCaseInstanceQuery;
import org.flowable.cmmn.engine.impl.cmd.DeleteHistoricCaseInstancesCmd;
import org.flowable.cmmn.engine.impl.cmd.DeleteRelatedDataOfRemovedHistoricCaseInstancesCmd;
import org.flowable.cmmn.engine.impl.cmd.DeleteTaskAndPlanItemInstanceDataOfRemovedHistoricCaseInstancesCmd;
import org.flowable.cmmn.engine.impl.history.HistoricCaseInstanceQueryProperty;
import org.flowable.cmmn.engine.impl.persistence.entity.HistoricCaseInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.QueryCacheValues;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandConfig;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.persistence.cache.EntityCache;
import org.flowable.variable.service.impl.AbstractVariableQueryImpl;
import org.flowable.variable.service.impl.persistence.entity.HistoricVariableInstanceEntity;

public class HistoricCaseInstanceQueryImpl
extends AbstractVariableQueryImpl<HistoricCaseInstanceQuery, HistoricCaseInstance>
implements HistoricCaseInstanceQuery,
QueryCacheValues {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected Set<String> caseDefinitionKeys;
    protected Set<String> caseDefinitionIds;
    protected String caseDefinitionName;
    protected String caseDefinitionCategory;
    protected Integer caseDefinitionVersion;
    protected String caseInstanceId;
    protected Set<String> caseInstanceIds;
    protected String caseInstanceNameLikeIgnoreCase;
    protected String businessKey;
    protected String caseInstanceParentId;
    protected String deploymentId;
    protected List<String> deploymentIds;
    protected boolean finished;
    protected boolean unfinished;
    protected Date startedBefore;
    protected Date startedAfter;
    protected Date finishedBefore;
    protected Date finishedAfter;
    protected String startedBy;
    protected String callbackId;
    protected String callbackType;
    protected String referenceId;
    protected String referenceType;
    protected String tenantId;
    protected boolean withoutTenantId;
    protected boolean includeCaseVariables;
    protected Integer caseVariablesLimit;
    protected String involvedUser;
    protected Set<String> involvedGroups;
    protected List<HistoricCaseInstanceQueryImpl> orQueryObjects = new ArrayList<HistoricCaseInstanceQueryImpl>();
    protected HistoricCaseInstanceQueryImpl currentOrQueryObject;
    protected boolean inOrStatement;

    public HistoricCaseInstanceQueryImpl() {
    }

    public HistoricCaseInstanceQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public HistoricCaseInstanceQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    protected void ensureVariablesInitialized() {
        super.ensureVariablesInitialized();
        for (HistoricCaseInstanceQueryImpl orQueryObject : this.orQueryObjects) {
            orQueryObject.ensureVariablesInitialized();
        }
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionId(String caseDefinitionId) {
        if (caseDefinitionId == null) {
            throw new FlowableIllegalArgumentException("Case definition id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionId = caseDefinitionId;
        } else {
            this.caseDefinitionId = caseDefinitionId;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionKey(String caseDefinitionKey) {
        if (caseDefinitionKey == null) {
            throw new FlowableIllegalArgumentException("Case definition key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionKey = caseDefinitionKey;
        } else {
            this.caseDefinitionKey = caseDefinitionKey;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionCategory(String caseDefinitionCategory) {
        if (caseDefinitionCategory == null) {
            throw new FlowableIllegalArgumentException("Case definition category is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionCategory = caseDefinitionCategory;
        } else {
            this.caseDefinitionCategory = caseDefinitionCategory;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionName(String caseDefinitionName) {
        if (caseDefinitionName == null) {
            throw new FlowableIllegalArgumentException("Case definition name is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionName = caseDefinitionName;
        } else {
            this.caseDefinitionName = caseDefinitionName;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionVersion(Integer caseDefinitionVersion) {
        if (caseDefinitionVersion == null) {
            throw new FlowableIllegalArgumentException("Case definition version is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionVersion = caseDefinitionVersion;
        } else {
            this.caseDefinitionVersion = caseDefinitionVersion;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceId(String caseInstanceId) {
        if (caseInstanceId == null) {
            throw new FlowableIllegalArgumentException("Case instance id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceId = caseInstanceId;
        } else {
            this.caseInstanceId = caseInstanceId;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceIds(Set<String> caseInstanceIds) {
        if (caseInstanceIds == null) {
            throw new FlowableIllegalArgumentException("Case instance ids is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceIds = caseInstanceIds;
        } else {
            this.caseInstanceIds = caseInstanceIds;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceBusinessKey(String businessKey) {
        if (businessKey == null) {
            throw new FlowableIllegalArgumentException("Business key is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.businessKey = businessKey;
        } else {
            this.businessKey = businessKey;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseDefinitionKeys(Set<String> caseDefinitionKeys) {
        if (caseDefinitionKeys == null) {
            throw new FlowableIllegalArgumentException("Case definition keys is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseDefinitionKeys = caseDefinitionKeys;
        } else {
            this.caseDefinitionKeys = caseDefinitionKeys;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceParentId(String parentId) {
        if (parentId == null) {
            throw new FlowableIllegalArgumentException("Parent id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceParentId = parentId;
        } else {
            this.caseInstanceParentId = parentId;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl deploymentId(String deploymentId) {
        if (deploymentId == null) {
            throw new FlowableIllegalArgumentException("Deployment id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.deploymentId = deploymentId;
        } else {
            this.deploymentId = deploymentId;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl deploymentIds(List<String> deploymentIds) {
        if (deploymentIds == null) {
            throw new FlowableIllegalArgumentException("Deployment ids is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.deploymentIds = deploymentIds;
        } else {
            this.deploymentIds = deploymentIds;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl finished() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.finished = true;
        } else {
            this.finished = true;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl unfinished() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.unfinished = true;
        } else {
            this.unfinished = true;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl finishedBefore(Date beforeTime) {
        if (beforeTime == null) {
            throw new FlowableIllegalArgumentException("before time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.finishedBefore = beforeTime;
        } else {
            this.finishedBefore = beforeTime;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl finishedAfter(Date afterTime) {
        if (afterTime == null) {
            throw new FlowableIllegalArgumentException("after time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.finishedAfter = afterTime;
        } else {
            this.finishedAfter = afterTime;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl startedBefore(Date beforeTime) {
        if (beforeTime == null) {
            throw new FlowableIllegalArgumentException("before time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedBefore = beforeTime;
        } else {
            this.startedBefore = beforeTime;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl startedAfter(Date afterTime) {
        if (afterTime == null) {
            throw new FlowableIllegalArgumentException("after time is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedAfter = afterTime;
        } else {
            this.startedAfter = afterTime;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl startedBy(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("user id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.startedBy = userId;
        } else {
            this.startedBy = userId;
        }
        return this;
    }

    public HistoricCaseInstanceQuery caseInstanceCallbackId(String callbackId) {
        if (callbackId == null) {
            throw new FlowableIllegalArgumentException("callback id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.callbackId = callbackId;
        } else {
            this.callbackId = callbackId;
        }
        return this;
    }

    public HistoricCaseInstanceQuery caseInstanceCallbackType(String callbackType) {
        if (callbackType == null) {
            throw new FlowableIllegalArgumentException("callback type is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.callbackType = callbackType;
        } else {
            this.callbackType = callbackType;
        }
        return this;
    }

    public HistoricCaseInstanceQuery caseInstanceReferenceId(String referenceId) {
        if (referenceId == null) {
            throw new FlowableIllegalArgumentException("referenceId is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.referenceId = referenceId;
        } else {
            this.referenceId = referenceId;
        }
        return this;
    }

    public HistoricCaseInstanceQuery caseInstanceReferenceType(String referenceType) {
        if (referenceType == null) {
            throw new FlowableIllegalArgumentException("referenceType is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.referenceType = referenceType;
        } else {
            this.referenceType = referenceType;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceTenantId(String tenantId) {
        if (tenantId == null) {
            throw new FlowableIllegalArgumentException("caseInstance tenant id is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.tenantId = tenantId;
        } else {
            this.tenantId = tenantId;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl caseInstanceWithoutTenantId() {
        if (this.inOrStatement) {
            this.currentOrQueryObject.withoutTenantId = true;
        } else {
            this.withoutTenantId = true;
        }
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByCaseInstanceId() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_INSTANCE_ID;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByCaseInstanceName() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_INSTANCE_NAME;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByCaseDefinitionId() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_DEFINITION_ID;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByCaseDefinitionKey() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_DEFINITION_KEY;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByStartTime() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_START_TIME;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByEndTime() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.CASE_END_TIME;
        return this;
    }

    public HistoricCaseInstanceQueryImpl orderByTenantId() {
        this.orderProperty = HistoricCaseInstanceQueryProperty.TENANT_ID;
        return this;
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        return CommandContextUtil.getHistoricCaseInstanceEntityManager(commandContext).countByCriteria(this);
    }

    public List<HistoricCaseInstance> executeList(CommandContext commandContext) {
        List<HistoricCaseInstance> results;
        this.ensureVariablesInitialized();
        if (this.includeCaseVariables) {
            results = CommandContextUtil.getHistoricCaseInstanceEntityManager(commandContext).findWithVariablesByQueryCriteria(this);
            if (this.caseInstanceId != null) {
                this.addCachedVariableForQueryById(commandContext, results);
            }
        } else {
            results = CommandContextUtil.getHistoricCaseInstanceEntityManager(commandContext).findByCriteria(this);
        }
        return results;
    }

    protected void addCachedVariableForQueryById(CommandContext commandContext, List<HistoricCaseInstance> results) {
        for (HistoricCaseInstance historicCaseInstance : results) {
            if (!Objects.equals(this.caseInstanceId, historicCaseInstance.getId())) continue;
            EntityCache entityCache = (EntityCache)commandContext.getSession(EntityCache.class);
            List cachedVariableEntities = entityCache.findInCache(HistoricVariableInstanceEntity.class);
            for (HistoricVariableInstanceEntity cachedVariableEntity : cachedVariableEntities) {
                if (!historicCaseInstance.getId().equals(cachedVariableEntity.getScopeId()) || !"cmmn".equals(cachedVariableEntity.getScopeType())) continue;
                ((HistoricCaseInstanceEntity)historicCaseInstance).getQueryVariables().add(cachedVariableEntity);
            }
        }
    }

    public void delete() {
        if (this.commandExecutor != null) {
            this.commandExecutor.execute((Command)new DeleteHistoricCaseInstancesCmd(this));
        } else {
            new DeleteHistoricCaseInstancesCmd(this).execute(Context.getCommandContext());
        }
    }

    public void deleteWithRelatedData() {
        if (this.commandExecutor == null) {
            throw new FlowableException("deleting historic case instances with related data requires CommandExecutor");
        }
        CommandConfig config = new CommandConfig().transactionRequiresNew();
        this.commandExecutor.execute(config, (Command)new DeleteHistoricCaseInstancesCmd(this));
        this.commandExecutor.execute(config, (Command)new DeleteTaskAndPlanItemInstanceDataOfRemovedHistoricCaseInstancesCmd());
        this.commandExecutor.execute(config, (Command)new DeleteRelatedDataOfRemovedHistoricCaseInstancesCmd());
    }

    public HistoricCaseInstanceQuery includeCaseVariables() {
        this.includeCaseVariables = true;
        return this;
    }

    public HistoricCaseInstanceQuery limitCaseVariables(Integer historicCaseVariablesLimit) {
        this.caseVariablesLimit = historicCaseVariablesLimit;
        return this;
    }

    public HistoricCaseInstanceQuery involvedUser(String userId) {
        if (userId == null) {
            throw new FlowableIllegalArgumentException("involvedUser is null");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedUser = userId;
        } else {
            this.involvedUser = userId;
        }
        return this;
    }

    public HistoricCaseInstanceQuery involvedGroups(Set<String> groupIds) {
        if (groupIds == null) {
            throw new FlowableIllegalArgumentException("involvedGroups are null");
        }
        if (groupIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("involvedGroups are empty");
        }
        if (this.inOrStatement) {
            this.currentOrQueryObject.involvedGroups = groupIds;
        } else {
            this.involvedGroups = groupIds;
        }
        return this;
    }

    public HistoricCaseInstanceQuery or() {
        if (this.inOrStatement) {
            throw new FlowableException("the query is already in an or statement");
        }
        this.inOrStatement = true;
        this.currentOrQueryObject = new HistoricCaseInstanceQueryImpl();
        this.orQueryObjects.add(this.currentOrQueryObject);
        return this;
    }

    public HistoricCaseInstanceQuery endOr() {
        if (!this.inOrStatement) {
            throw new FlowableException("endOr() can only be called after calling or()");
        }
        this.inOrStatement = false;
        this.currentOrQueryObject = null;
        return this;
    }

    public HistoricCaseInstanceQuery variableValueEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableName, variableValue, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueEquals(variableName, variableValue, false);
    }

    public HistoricCaseInstanceQuery variableValueNotEquals(String variableName, Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEquals(variableName, variableValue, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueNotEquals(variableName, variableValue, false);
    }

    public HistoricCaseInstanceQuery variableValueEquals(Object variableValue) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEquals(variableValue, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueEquals(variableValue, false);
    }

    public HistoricCaseInstanceQuery variableValueEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueEqualsIgnoreCase(name, value, false);
    }

    public HistoricCaseInstanceQuery variableValueNotEqualsIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueNotEqualsIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueNotEqualsIgnoreCase(name, value, false);
    }

    public HistoricCaseInstanceQuery variableValueLikeIgnoreCase(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLikeIgnoreCase(name, value, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueLikeIgnoreCase(name, value, false);
    }

    public HistoricCaseInstanceQueryImpl caseInstanceNameLikeIgnoreCase(String nameLikeIgnoreCase) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.caseInstanceNameLikeIgnoreCase = nameLikeIgnoreCase;
        } else {
            this.caseInstanceNameLikeIgnoreCase = nameLikeIgnoreCase;
        }
        return this;
    }

    public HistoricCaseInstanceQuery variableValueGreaterThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThan(name, value, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueGreaterThan(name, value, false);
    }

    public HistoricCaseInstanceQuery variableValueGreaterThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueGreaterThanOrEqual(name, value, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueGreaterThanOrEqual(name, value, false);
    }

    public HistoricCaseInstanceQuery variableValueLessThan(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThan(name, value, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueLessThan(name, value, false);
    }

    public HistoricCaseInstanceQuery variableValueLessThanOrEqual(String name, Object value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLessThanOrEqual(name, value, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueLessThanOrEqual(name, value, false);
    }

    public HistoricCaseInstanceQuery variableValueLike(String name, String value) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableValueLike(name, value, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableValueLike(name, value, false);
    }

    public HistoricCaseInstanceQuery variableExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableExists(name, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableExists(name, false);
    }

    public HistoricCaseInstanceQuery variableNotExists(String name) {
        if (this.inOrStatement) {
            this.currentOrQueryObject.variableNotExists(name, false);
            return this;
        }
        return (HistoricCaseInstanceQuery)this.variableNotExists(name, false);
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public Set<String> getCaseDefinitionKeys() {
        return this.caseDefinitionKeys;
    }

    public Set<String> getCaseDefinitionIds() {
        return this.caseDefinitionIds;
    }

    public String getCaseDefinitionName() {
        return this.caseDefinitionName;
    }

    public String getCaseDefinitionCategory() {
        return this.caseDefinitionCategory;
    }

    public Integer getCaseDefinitionVersion() {
        return this.caseDefinitionVersion;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getId() {
        return this.caseInstanceId;
    }

    public String getCaseInstanceNameLikeIgnoreCase() {
        return this.caseInstanceNameLikeIgnoreCase;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getCaseInstanceParentId() {
        return this.caseInstanceParentId;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isUnfinished() {
        return this.unfinished;
    }

    public Date getStartedBefore() {
        return this.startedBefore;
    }

    public Date getStartedAfter() {
        return this.startedAfter;
    }

    public Date getFinishedBefore() {
        return this.finishedBefore;
    }

    public Date getFinishedAfter() {
        return this.finishedAfter;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public String getCallbackId() {
        return this.callbackId;
    }

    public String getCallbackType() {
        return this.callbackType;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public boolean isWithoutTenantId() {
        return this.withoutTenantId;
    }

    public String getInvolvedUser() {
        return this.involvedUser;
    }

    public Set<String> getInvolvedGroups() {
        return this.involvedGroups;
    }

    public boolean isIncludeCaseVariables() {
        return this.includeCaseVariables;
    }

    public Integer getCaseVariablesLimit() {
        return this.caseVariablesLimit;
    }

    public List<HistoricCaseInstanceQueryImpl> getOrQueryObjects() {
        return this.orQueryObjects;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public List<String> getDeploymentIds() {
        return this.deploymentIds;
    }

    public Set<String> getCaseInstanceIds() {
        return this.caseInstanceIds;
    }

    public String getMssqlOrDB2OrderBy() {
        String specialOrderBy = super.getOrderByColumns();
        if (specialOrderBy != null && specialOrderBy.length() > 0) {
            specialOrderBy = specialOrderBy.replace("RES.", "TEMPRES_");
        }
        return specialOrderBy;
    }
}

