/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.listener;

import org.flowable.cmmn.api.listener.CaseInstanceLifecycleListener;
import org.flowable.cmmn.api.listener.PlanItemInstanceLifecycleListener;
import org.flowable.cmmn.engine.impl.listener.CmmnListenerFactory;
import org.flowable.cmmn.engine.impl.repository.CaseDefinitionUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.CaseElement;
import org.flowable.cmmn.model.CmmnModel;
import org.flowable.cmmn.model.FlowableListener;
import org.flowable.cmmn.model.HumanTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.task.service.delegate.TaskListener;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public class CmmnListenerNotificationHelper {
    public void executeTaskListeners(TaskEntity taskEntity, String eventType) {
        CmmnModel cmmnModel;
        CaseElement caseElement;
        if (taskEntity.getScopeDefinitionId() != null && (caseElement = (CaseElement)(cmmnModel = CaseDefinitionUtil.getCmmnModel(taskEntity.getScopeDefinitionId())).getPrimaryCase().getAllCaseElements().get(taskEntity.getTaskDefinitionKey())) instanceof HumanTask) {
            HumanTask humanTask = (HumanTask)caseElement;
            this.executeTaskListeners(humanTask, taskEntity, eventType);
        }
    }

    public void executeTaskListeners(HumanTask humanTask, TaskEntity taskEntity, String eventType) {
        for (FlowableListener listener : humanTask.getTaskListeners()) {
            String event = listener.getEvent();
            if (!event.equals(eventType) && !event.equals("all")) continue;
            TaskListener taskListener = this.createTaskListener(listener);
            taskEntity.setEventName(eventType);
            taskEntity.setEventHandlerId(listener.getId());
            try {
                taskListener.notify((DelegateTask)taskEntity);
            }
            catch (Exception e) {
                throw new FlowableException("Exception while invoking TaskListener: " + e.getMessage(), (Throwable)e);
            }
            finally {
                taskEntity.setEventName(null);
            }
        }
    }

    protected TaskListener createTaskListener(FlowableListener listener) {
        TaskListener taskListener = null;
        CmmnListenerFactory listenerFactory = CommandContextUtil.getCmmnEngineConfiguration().getListenerFactory();
        if ("class".equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = listenerFactory.createClassDelegateTaskListener(listener);
        } else if ("expression".equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = listenerFactory.createExpressionTaskListener(listener);
        } else if ("delegateExpression".equalsIgnoreCase(listener.getImplementationType())) {
            taskListener = listenerFactory.createDelegateExpressionTaskListener(listener);
        }
        return taskListener;
    }

    protected PlanItemInstanceLifecycleListener createLifecycleListener(FlowableListener listener) {
        PlanItemInstanceLifecycleListener lifecycleListener = null;
        CmmnListenerFactory listenerFactory = CommandContextUtil.getCmmnEngineConfiguration().getListenerFactory();
        if ("class".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createClassDelegateLifeCycleListener(listener);
        } else if ("expression".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createExpressionLifeCycleListener(listener);
        } else if ("delegateExpression".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createDelegateExpressionLifeCycleListener(listener);
        }
        return lifecycleListener;
    }

    protected CaseInstanceLifecycleListener createCaseLifecycleListener(FlowableListener listener) {
        CaseInstanceLifecycleListener lifecycleListener = null;
        CmmnListenerFactory listenerFactory = CommandContextUtil.getCmmnEngineConfiguration().getListenerFactory();
        if ("class".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createClassDelegateCaseLifeCycleListener(listener);
        } else if ("expression".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createExpressionCaseLifeCycleListener(listener);
        } else if ("delegateExpression".equalsIgnoreCase(listener.getImplementationType())) {
            lifecycleListener = listenerFactory.createDelegateExpressionCaseLifeCycleListener(listener);
        }
        return lifecycleListener;
    }
}

