/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.ManagementService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.job.api.Job;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class HandleHistoryCleanupTimerJobCmd
implements Command<Object>,
Serializable {
    private static final long serialVersionUID = 1L;

    public Object execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ManagementService managementService = processEngineConfiguration.getManagementService();
        TimerJobService timerJobService = CommandContextUtil.getTimerJobService(commandContext);
        List cleanupJobs = managementService.createTimerJobQuery().handlerType("bpmn-history-cleanup").list();
        if (cleanupJobs.isEmpty()) {
            TimerJobEntity timerJob = timerJobService.createTimerJob();
            timerJob.setJobType("timer");
            timerJob.setRevision(1);
            timerJob.setJobHandlerType("bpmn-history-cleanup");
            BusinessCalendar businessCalendar = processEngineConfiguration.getBusinessCalendarManager().getBusinessCalendar("cycle");
            timerJob.setDuedate(businessCalendar.resolveDuedate(processEngineConfiguration.getHistoryCleaningTimeCycleConfig()));
            timerJob.setRepeat(processEngineConfiguration.getHistoryCleaningTimeCycleConfig());
            timerJobService.scheduleTimerJob(timerJob);
        } else if (cleanupJobs.size() > 1) {
            for (int i = 1; i < cleanupJobs.size(); ++i) {
                managementService.deleteTimerJob(((Job)cleanupJobs.get(i)).getId());
            }
        }
        return null;
    }
}

