/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.IOParameter;
import org.flowable.bpmn.model.SendEventServiceTask;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.api.runtime.EventPayloadInstance;
import org.flowable.eventregistry.impl.runtime.EventPayloadInstanceImpl;
import org.flowable.eventregistry.model.EventModel;
import org.flowable.eventregistry.model.EventPayload;
import org.flowable.variable.api.delegate.VariableScope;

public class EventInstanceBpmnUtil {
    public static void handleEventInstanceOutParameters(VariableScope variableScope, BaseElement baseElement, EventInstance eventInstance) {
        block4: {
            Map<String, EventPayloadInstance> payloadInstances;
            block3: {
                payloadInstances = eventInstance.getPayloadInstances().stream().collect(Collectors.toMap(EventPayloadInstance::getDefinitionName, Function.identity()));
                if (!(baseElement instanceof SendEventServiceTask)) break block3;
                SendEventServiceTask eventServiceTask = (SendEventServiceTask)baseElement;
                if (eventServiceTask.getEventOutParameters().isEmpty()) break block4;
                for (IOParameter parameter : eventServiceTask.getEventOutParameters()) {
                    EventInstanceBpmnUtil.setEventParameterVariable(parameter.getSource(), parameter.getTarget(), parameter.isTransient(), payloadInstances, variableScope);
                }
                break block4;
            }
            List outParameters = baseElement.getExtensionElements().getOrDefault("eventOutParameter", Collections.emptyList());
            if (!outParameters.isEmpty()) {
                for (ExtensionElement outParameter : outParameters) {
                    String payloadSourceName = outParameter.getAttributeValue(null, "source");
                    String variableName = outParameter.getAttributeValue(null, "target");
                    Boolean isTransient = Boolean.valueOf(outParameter.getAttributeValue(null, "transient"));
                    EventInstanceBpmnUtil.setEventParameterVariable(payloadSourceName, variableName, isTransient, payloadInstances, variableScope);
                }
            }
        }
    }

    public static Collection<EventPayloadInstance> createEventPayloadInstances(VariableScope variableScope, ExpressionManager expressionManager, BaseElement baseElement, EventModel eventDefinition) {
        ArrayList<EventPayloadInstance> eventPayloadInstances;
        block4: {
            block3: {
                eventPayloadInstances = new ArrayList<EventPayloadInstance>();
                if (!(baseElement instanceof SendEventServiceTask)) break block3;
                SendEventServiceTask eventServiceTask = (SendEventServiceTask)baseElement;
                if (eventServiceTask.getEventInParameters().isEmpty()) break block4;
                for (IOParameter parameter : eventServiceTask.getEventInParameters()) {
                    String sourceValue = null;
                    sourceValue = StringUtils.isNotEmpty((CharSequence)parameter.getSourceExpression()) ? parameter.getSourceExpression() : parameter.getSource();
                    EventInstanceBpmnUtil.addEventPayloadInstance(eventPayloadInstances, sourceValue, parameter.getTarget(), variableScope, expressionManager, eventDefinition);
                }
                break block4;
            }
            List inParameters = baseElement.getExtensionElements().getOrDefault("eventInParameter", Collections.emptyList());
            if (!inParameters.isEmpty()) {
                for (ExtensionElement inParameter : inParameters) {
                    String sourceExpression = inParameter.getAttributeValue(null, "sourceExpression");
                    String source = inParameter.getAttributeValue(null, "source");
                    String target = inParameter.getAttributeValue(null, "target");
                    String sourceValue = null;
                    sourceValue = StringUtils.isNotEmpty((CharSequence)sourceExpression) ? sourceExpression : source;
                    EventInstanceBpmnUtil.addEventPayloadInstance(eventPayloadInstances, sourceValue, target, variableScope, expressionManager, eventDefinition);
                }
            }
        }
        return eventPayloadInstances;
    }

    protected static void setEventParameterVariable(String source, String target, boolean isTransient, Map<String, EventPayloadInstance> payloadInstances, VariableScope variableScope) {
        EventPayloadInstance payloadInstance = payloadInstances.get(source);
        if (StringUtils.isNotEmpty((CharSequence)target)) {
            Object value;
            Object object = value = payloadInstance != null ? payloadInstance.getValue() : null;
            if (Boolean.TRUE.equals(isTransient)) {
                variableScope.setTransientVariable(target, value);
            } else {
                variableScope.setVariable(target, value);
            }
        }
    }

    protected static void addEventPayloadInstance(List<EventPayloadInstance> eventPayloadInstances, String source, String target, VariableScope variableScope, ExpressionManager expressionManager, EventModel eventDefinition) {
        Optional<EventPayload> matchingEventDefinition = eventDefinition.getPayload().stream().filter(e -> e.getName().equals(target)).findFirst();
        if (matchingEventDefinition.isPresent()) {
            EventPayload eventPayloadDefinition = matchingEventDefinition.get();
            Expression sourceExpression = expressionManager.createExpression(source);
            Object value = sourceExpression.getValue((VariableContainer)variableScope);
            eventPayloadInstances.add((EventPayloadInstance)new EventPayloadInstanceImpl(eventPayloadDefinition, value));
        }
    }
}

