/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.extensibility;

import java.time.Duration;
import java.time.Instant;
import org.flywaydb.core.FlywayTelemetryManager;

public class EventTelemetryModel
implements AutoCloseable {
    private String name;
    private long duration;
    private Exception exception;
    private final FlywayTelemetryManager flywayTelemetryManager;
    private Instant startTime = Instant.now();

    public EventTelemetryModel(String name, FlywayTelemetryManager flywayTelemetryManager) {
        this.flywayTelemetryManager = flywayTelemetryManager;
        this.name = name;
    }

    @Override
    public void close() {
        this.duration = Duration.between(this.startTime, Instant.now()).toMillis();
        if (this.flywayTelemetryManager != null) {
            this.flywayTelemetryManager.logEvent(this);
        }
    }

    public String getName() {
        return this.name;
    }

    public long getDuration() {
        return this.duration;
    }

    public Exception getException() {
        return this.exception;
    }

    public FlywayTelemetryManager getFlywayTelemetryManager() {
        return this.flywayTelemetryManager;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setStartTime(Instant startTime) {
        this.startTime = startTime;
    }
}

