/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.IOUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class FileUtils {
    public static String getFilename(String path) {
        if (StringUtils.hasText(path)) {
            return path.substring(path.replace("/", "\\").lastIndexOf("\\") + 1);
        }
        return "";
    }

    public static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        FileUtils.copy(in, out);
        String str = out.toString();
        if (str.startsWith("\ufeff")) {
            return str.substring(1);
        }
        return str;
    }

    public static String copyToString(InputStream in, Charset encoding) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        FileUtils.copy(in, out);
        return out.toString(encoding.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Reader in, Writer out) throws IOException {
        try {
            int bytesRead;
            char[] buffer = new char[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        finally {
            IOUtils.close(in);
            IOUtils.close(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream in, OutputStream out) throws IOException {
        try {
            int bytesRead;
            int byteCount = 0;
            byte[] buffer = new byte[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                byteCount += bytesRead;
            }
            out.flush();
            int n = byteCount;
            return n;
        }
        finally {
            IOUtils.close(in);
            IOUtils.close(out);
        }
    }

    private static String readAsString(Path path, Charset charset) {
        try {
            return String.join((CharSequence)System.lineSeparator(), Files.readAllLines(path.toAbsolutePath(), charset));
        }
        catch (IOException ioe) {
            throw new FlywayException("Unable to read " + path.toAbsolutePath() + " from disk", ioe);
        }
    }

    public static String readAsString(Path path) {
        return FileUtils.readAsString(path, StandardCharsets.UTF_8);
    }

    public static String readResourceAsString(String path) {
        return FileUtils.readResourceAsString(FileUtils.class.getClassLoader(), path);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String readResourceAsString(ClassLoader classLoader, String path) {
        try (InputStream inputStream = classLoader.getResourceAsStream(path);){
            String string;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                Object result = "";
                while (reader.ready()) {
                    result = (String)result + reader.readLine() + System.lineSeparator();
                }
                string = result;
            }
            return string;
        }
        catch (IOException ioe) {
            throw new FlywayException("Unable to read " + path + " from resources", ioe);
        }
    }

    public static String readAsStringFallbackToResource(String parent, String path) {
        try {
            return FileUtils.readAsString(Paths.get(parent, path), Charset.defaultCharset()) + System.lineSeparator();
        }
        catch (FlywayException fe) {
            return FileUtils.readResourceAsString(path);
        }
    }

    public static void createDirIfNotExists(File file) {
        File dir = file.getParentFile();
        if (dir == null || dir.exists()) {
            throw new UnsupportedOperationException("No need to create report file directory");
        }
        if (!dir.mkdirs()) {
            throw new FlywayException("Unable to creat report file directory");
        }
    }

    public static File getAppDataLocation() {
        boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
        return isWindows ? new File(System.getenv("APPDATA"), "Redgate") : new File(System.getProperty("user.home"), ".config/Redgate");
    }

    public static File getAppDataFlywayCLILocation() {
        File redgateAppData = FileUtils.getAppDataLocation();
        return new File(redgateAppData, "Flyway CLI");
    }

    public static void writeToFile(File file, String content) {
        try (FileWriter fileWriter = new FileWriter(file);){
            fileWriter.write(content);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to write to " + file.getAbsolutePath(), e);
        }
    }

    private FileUtils() {
    }
}

