/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental;

import java.util.List;
import java.util.Map;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.configuration.ConfigurationValidator;

public class ExperimentalModeUtils {
    private static final Log LOG = LogFactory.getLog(ExperimentalModeUtils.class);
    private static final Map<String, List<String>> ACCEPTED_VERBS = Map.of("mongodb", List.of("info", "validate", "migrate", "clean", "baseline", "repair", "undo"), "SQLite", List.of("info", "validate", "migrate", "clean", "undo", "baseline", "repair"));

    public static boolean isExperimentalModeActivated() {
        return System.getenv("FLYWAY_EXPERIMENTAL") != null && System.getenv("FLYWAY_EXPERIMENTAL").equalsIgnoreCase("true");
    }

    public static boolean canUseExperimentalMode(Configuration config, String verb) {
        if (!ExperimentalModeUtils.isExperimentalModeActivated()) {
            return false;
        }
        if (ExperimentalModeUtils.useLegacyAsDryRunSet(config)) {
            LOG.warn("Dry run is not supported in experimental databases, falling back to legacy databases");
            return false;
        }
        new ConfigurationValidator().validate(config);
        String database = ExperimentalModeUtils.getCurrentDatabase(config);
        if (database == null) {
            return false;
        }
        if (!ACCEPTED_VERBS.containsKey(database)) {
            return false;
        }
        return ACCEPTED_VERBS.get(database).contains(verb);
    }

    public static boolean canCreateDataSource(Configuration config) {
        if (!ExperimentalModeUtils.isExperimentalModeActivated() || ExperimentalModeUtils.useLegacyAsDryRunSet(config)) {
            return true;
        }
        String database = ExperimentalModeUtils.getCurrentDatabase(config);
        if (database == null) {
            return true;
        }
        return !"mongodb".equals(database);
    }

    private static boolean useLegacyAsDryRunSet(Configuration config) {
        return config.getDryRunOutput() != null;
    }

    private static String getCurrentDatabase(Configuration config) {
        if (config.getUrl().startsWith("mongodb")) {
            return "mongodb";
        }
        if (config.getUrl().startsWith("jdbc:sqlite")) {
            return "SQLite";
        }
        return null;
    }
}

