/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.experimental;

import java.util.List;
import java.util.Map;
import org.flywaydb.core.FlywayTelemetryManager;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.experimental.MetaData;
import org.flywaydb.core.extensibility.LicenseGuard;
import org.flywaydb.core.internal.configuration.ConfigurationValidator;

public class ExperimentalModeUtils {
    private static final Log LOG = LogFactory.getLog(ExperimentalModeUtils.class);
    private static final Map<String, List<String>> EXPERIMENTAL_DATABASES = Map.of("SQLite", List.of("info", "validate", "migrate", "clean", "undo", "baseline", "repair"));
    private static final Map<String, List<String>> DEFAULT_DATABASES = Map.of("mongodb", List.of("info", "validate", "migrate", "clean", "baseline", "repair", "undo"));

    private static boolean isExperimentalModeActivated(Configuration configuration) {
        if ("OSS".equals(LicenseGuard.getTierAsString(configuration))) {
            return System.getenv("FLYWAY_NATIVE_CONNECTORS") == null || System.getenv("FLYWAY_NATIVE_CONNECTORS").equalsIgnoreCase("true");
        }
        return System.getenv("FLYWAY_NATIVE_CONNECTORS") != null && System.getenv("FLYWAY_NATIVE_CONNECTORS").equalsIgnoreCase("true");
    }

    public static boolean canUseExperimentalMode(Configuration config, String verb) {
        if (!ExperimentalModeUtils.isExperimentalModeActivated(config)) {
            return false;
        }
        if (ExperimentalModeUtils.useLegacyAsDryRunSet(config)) {
            LOG.warn("Dry run is not supported in experimental databases, falling back to legacy databases");
            return false;
        }
        new ConfigurationValidator().validate(config);
        String database = ExperimentalModeUtils.getCurrentDatabase(config);
        if (database == null) {
            return false;
        }
        if (DEFAULT_DATABASES.containsKey(database)) {
            return DEFAULT_DATABASES.get(database).contains(verb);
        }
        if (EXPERIMENTAL_DATABASES.containsKey(database) && System.getenv("FLYWAY_NATIVE_CONNECTORS") != null) {
            return EXPERIMENTAL_DATABASES.get(database).contains(verb);
        }
        return false;
    }

    public static boolean canCreateDataSource(Configuration config) {
        if (ExperimentalModeUtils.useLegacyAsDryRunSet(config)) {
            return true;
        }
        String database = ExperimentalModeUtils.getCurrentDatabase(config);
        if (ExperimentalModeUtils.isExperimentalModeActivated(config)) {
            return !"mongodb".equals(database);
        }
        return true;
    }

    public static void logExperimentalDataTelemetry(FlywayTelemetryManager flywayTelemetryManager, MetaData metaData) {
        if (flywayTelemetryManager != null) {
            flywayTelemetryManager.notifyExperimentalMetadataChanged(metaData);
        }
    }

    private static boolean useLegacyAsDryRunSet(Configuration config) {
        return config.getDryRunOutput() != null;
    }

    private static String getCurrentDatabase(Configuration config) {
        if (config.getUrl() == null) {
            return null;
        }
        if (config.getUrl().startsWith("mongodb") || config.getUrl().startsWith("jdbc:mongodb")) {
            return "mongodb";
        }
        if (config.getUrl().startsWith("jdbc:sqlite")) {
            return "SQLite";
        }
        return null;
    }
}

