/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.dbsupport.postgresql;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.flywaydb.core.internal.dbsupport.Delimiter;
import org.flywaydb.core.internal.dbsupport.SqlStatementBuilder;
import org.flywaydb.core.internal.util.StringUtils;

public class PostgreSQLSqlStatementBuilder
extends SqlStatementBuilder {
    private static final Delimiter COPY_DELIMITER = new Delimiter("\\.", true);
    static final String DOLLAR_QUOTE_REGEX = "(\\$[A-Za-z0-9_]*\\$).*";
    private boolean firstLine = true;
    private String copyStatement;
    private boolean pgCopy;
    private String statementStart = "";

    @Override
    protected void applyStateChanges(String line) {
        super.applyStateChanges(line);
        if (!this.executeInTransaction) {
            return;
        }
        if (StringUtils.countOccurrencesOf(this.statementStart, " ") < 8) {
            this.statementStart = this.statementStart + line;
            this.statementStart = this.statementStart + " ";
            this.statementStart = this.statementStart.replaceAll("\\s+", " ");
        }
        if (this.statementStart.matches("(CREATE|DROP) (DATABASE|TABLESPACE) .*") || this.statementStart.matches("ALTER SYSTEM .*") || this.statementStart.matches("(CREATE|DROP)( UNIQUE)? INDEX CONCURRENTLY .*") || this.statementStart.matches("REINDEX( VERBOSE)? (SCHEMA|DATABASE|SYSTEM) .*") || this.statementStart.matches("VACUUM .*") || this.statementStart.matches("DISCARD ALL .*") || this.statementStart.matches("ALTER TYPE .* ADD VALUE .*")) {
            this.executeInTransaction = false;
        }
    }

    @Override
    protected String[] tokenizeLine(String line) {
        return StringUtils.tokenizeToStringArray(line, " @<>;:=|(),+{}\\[\\]");
    }

    @Override
    protected String extractAlternateOpenQuote(String token) {
        Matcher matcher = Pattern.compile(DOLLAR_QUOTE_REGEX).matcher(token);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (this.pgCopy) {
            return COPY_DELIMITER;
        }
        if (this.firstLine) {
            this.firstLine = false;
            if (line.matches("COPY|COPY\\s.*")) {
                this.copyStatement = line;
            }
        } else if (this.copyStatement != null) {
            this.copyStatement = this.copyStatement + " " + line;
        }
        if (this.copyStatement != null && this.copyStatement.contains(" FROM STDIN")) {
            this.pgCopy = true;
            return COPY_DELIMITER;
        }
        return delimiter;
    }

    @Override
    public boolean isPgCopyFromStdIn() {
        return this.pgCopy;
    }

    @Override
    protected String cleanToken(String token) {
        if (token.startsWith("E'")) {
            return token.substring(token.indexOf("'"));
        }
        return token;
    }
}

