/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util.scanner.classpath;

import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.internal.util.ClassUtils;
import org.flywaydb.core.internal.util.FeatureDetector;
import org.flywaydb.core.internal.util.Location;
import org.flywaydb.core.internal.util.UrlUtils;
import org.flywaydb.core.internal.util.logging.Log;
import org.flywaydb.core.internal.util.logging.LogFactory;
import org.flywaydb.core.internal.util.scanner.Resource;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathLocationScanner;
import org.flywaydb.core.internal.util.scanner.classpath.ClassPathResource;
import org.flywaydb.core.internal.util.scanner.classpath.DefaultUrlResolver;
import org.flywaydb.core.internal.util.scanner.classpath.FileSystemClassPathLocationScanner;
import org.flywaydb.core.internal.util.scanner.classpath.JarFileClassPathLocationScanner;
import org.flywaydb.core.internal.util.scanner.classpath.OsgiClassPathLocationScanner;
import org.flywaydb.core.internal.util.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.util.scanner.classpath.UrlResolver;
import org.flywaydb.core.internal.util.scanner.classpath.jboss.JBossVFSv2UrlResolver;
import org.flywaydb.core.internal.util.scanner.classpath.jboss.JBossVFSv3ClassPathLocationScanner;

public class ClassPathScanner
implements ResourceAndClassScanner {
    private static final Log LOG = LogFactory.getLog(ClassPathScanner.class);
    private final ClassLoader classLoader;
    private final Map<Location, List<URL>> locationUrlCache = new HashMap<Location, List<URL>>();
    private final Map<String, ClassPathLocationScanner> locationScannerCache = new HashMap<String, ClassPathLocationScanner>();
    private final Map<ClassPathLocationScanner, Map<URL, Set<String>>> resourceNameCache = new HashMap<ClassPathLocationScanner, Map<URL, Set<String>>>();

    public ClassPathScanner(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Resource[] scanForResources(Location path, String prefix, String suffix) throws IOException {
        LOG.debug("Scanning for classpath resources at '" + path + "' (Prefix: '" + prefix + "', Suffix: '" + suffix + "')");
        TreeSet<ClassPathResource> resources = new TreeSet<ClassPathResource>();
        Set<String> resourceNames = this.findResourceNames(path, prefix, suffix);
        for (String resourceName : resourceNames) {
            resources.add(new ClassPathResource(resourceName, this.classLoader));
            LOG.debug("Found resource: " + resourceName);
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    @Override
    public Class<?>[] scanForClasses(Location location, Class<?> implementedInterface) throws Exception {
        LOG.debug("Scanning for classes at '" + location + "' (Implementing: '" + implementedInterface.getName() + "')");
        ArrayList classes = new ArrayList();
        Set<String> resourceNames = this.findResourceNames(location, "", ".class");
        for (String resourceName : resourceNames) {
            Class<?> clazz;
            String className = this.toClassName(resourceName);
            try {
                clazz = this.classLoader.loadClass(className);
                if (!implementedInterface.isAssignableFrom(clazz)) continue;
                if (Modifier.isAbstract(clazz.getModifiers()) || clazz.isEnum() || clazz.isAnonymousClass()) {
                    LOG.debug("Skipping non-instantiable class: " + className);
                    continue;
                }
                ClassUtils.instantiate(className, this.classLoader);
            }
            catch (InternalError e) {
                LOG.debug("Skipping invalid class: " + className);
                continue;
            }
            catch (IncompatibleClassChangeError e) {
                LOG.debug("Skipping incompatibly changed class: " + className);
                continue;
            }
            catch (NoClassDefFoundError e) {
                LOG.debug("Skipping non-loadable class: " + className);
                continue;
            }
            catch (Exception e) {
                throw new FlywayException("Unable to instantiate class: " + className, e);
            }
            classes.add(clazz);
            LOG.debug("Found class: " + className);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> findResourceNames(Location location, String prefix, String suffix) throws IOException {
        boolean locationResolved;
        TreeSet<String> resourceNames = new TreeSet<String>();
        List<URL> locationUrls = this.getLocationUrlsForPath(location);
        for (URL locationUrl : locationUrls) {
            LOG.debug("Scanning URL: " + locationUrl.toExternalForm());
            UrlResolver urlResolver = this.createUrlResolver(locationUrl.getProtocol());
            URL resolvedUrl = urlResolver.toStandardJavaUrl(locationUrl);
            String protocol = resolvedUrl.getProtocol();
            ClassPathLocationScanner classPathLocationScanner = this.createLocationScanner(protocol);
            if (classPathLocationScanner == null) {
                String scanRoot = UrlUtils.toFilePath(resolvedUrl);
                LOG.warn("Unable to scan location: " + scanRoot + " (unsupported protocol: " + protocol + ")");
                continue;
            }
            Set<String> names = this.resourceNameCache.get(classPathLocationScanner).get(resolvedUrl);
            if (names == null) {
                names = classPathLocationScanner.findResourceNames(location.getPath(), resolvedUrl);
                this.resourceNameCache.get(classPathLocationScanner).put(resolvedUrl, names);
            }
            resourceNames.addAll(names);
        }
        boolean bl = locationResolved = !locationUrls.isEmpty();
        if (this.classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)this.classLoader;
            for (URL url : urlClassLoader.getURLs()) {
                JarFile jarFile;
                if (!"file".equals(url.getProtocol()) || !url.getPath().endsWith(".jar") || url.getPath().matches(".*" + Pattern.quote("/jre/lib/") + ".*")) continue;
                try {
                    jarFile = new JarFile(url.toURI().getSchemeSpecificPart());
                }
                catch (URISyntaxException ex) {
                    jarFile = new JarFile(url.getPath().substring("file:".length()));
                }
                try {
                    boolean directoryFound = false;
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        if (!entries.nextElement().isDirectory()) continue;
                        directoryFound = true;
                        break;
                    }
                    if (directoryFound) continue;
                    entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        String entryName = entries.nextElement().getName();
                        if (!entryName.startsWith(location.getPath())) continue;
                        locationResolved = true;
                        if (!entryName.endsWith(suffix)) continue;
                        resourceNames.add(entryName);
                    }
                }
                finally {
                    jarFile.close();
                }
            }
        }
        if (!locationResolved) {
            LOG.warn("Unable to resolve location " + location);
        }
        return this.filterResourceNames(resourceNames, prefix, suffix);
    }

    private List<URL> getLocationUrlsForPath(Location location) throws IOException {
        if (this.locationUrlCache.containsKey(location)) {
            return this.locationUrlCache.get(location);
        }
        LOG.debug("Determining location urls for " + location + " using ClassLoader " + this.classLoader + " ...");
        ArrayList<URL> locationUrls = new ArrayList<URL>();
        if (this.classLoader.getClass().getName().startsWith("com.ibm")) {
            Enumeration<URL> urls = this.classLoader.getResources(location.getPath() + "/flyway.location");
            if (!urls.hasMoreElements()) {
                LOG.warn("Unable to resolve location " + location + " (ClassLoader: " + this.classLoader + ")" + " On WebSphere an empty file named flyway.location must be present on the classpath location for WebSphere to find it!");
            }
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                locationUrls.add(new URL(URLDecoder.decode(url.toExternalForm(), "UTF-8").replace("/flyway.location", "")));
            }
        } else {
            Enumeration<URL> urls = this.classLoader.getResources(location.getPath());
            while (urls.hasMoreElements()) {
                locationUrls.add(urls.nextElement());
            }
        }
        this.locationUrlCache.put(location, locationUrls);
        return locationUrls;
    }

    private UrlResolver createUrlResolver(String protocol) {
        if (new FeatureDetector(this.classLoader).isJBossVFSv2Available() && protocol.startsWith("vfs")) {
            return new JBossVFSv2UrlResolver();
        }
        return new DefaultUrlResolver();
    }

    private ClassPathLocationScanner createLocationScanner(String protocol) {
        if (this.locationScannerCache.containsKey(protocol)) {
            return this.locationScannerCache.get(protocol);
        }
        if ("file".equals(protocol)) {
            FileSystemClassPathLocationScanner locationScanner = new FileSystemClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        if ("jar".equals(protocol) || "war".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol)) {
            JarFileClassPathLocationScanner locationScanner = "war".equals(protocol) ? new JarFileClassPathLocationScanner("*/") : new JarFileClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        FeatureDetector featureDetector = new FeatureDetector(this.classLoader);
        if (featureDetector.isJBossVFSv3Available() && "vfs".equals(protocol)) {
            JBossVFSv3ClassPathLocationScanner locationScanner = new JBossVFSv3ClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        if (featureDetector.isOsgiFrameworkAvailable() && ("bundle".equals(protocol) || "bundleresource".equals(protocol))) {
            OsgiClassPathLocationScanner locationScanner = new OsgiClassPathLocationScanner();
            this.locationScannerCache.put(protocol, locationScanner);
            this.resourceNameCache.put(locationScanner, new HashMap());
            return locationScanner;
        }
        return null;
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, String prefix, String suffix) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            String fileName = resourceName.substring(resourceName.lastIndexOf("/") + 1);
            if (fileName.startsWith(prefix) && fileName.endsWith(suffix) && fileName.length() > (prefix + suffix).length()) {
                filteredResourceNames.add(resourceName);
                continue;
            }
            LOG.debug("Filtering out resource: " + resourceName + " (filename: " + fileName + ")");
        }
        return filteredResourceNames;
    }
}

