/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.scanner.android;

import android.content.Context;
import dalvik.system.DexFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.Location;
import org.flywaydb.core.api.android.ContextHolder;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.android.AndroidResource;
import org.flywaydb.core.internal.scanner.classpath.ResourceAndClassScanner;
import org.flywaydb.core.internal.util.ClassUtils;

public class AndroidScanner
implements ResourceAndClassScanner {
    private static final Log LOG = LogFactory.getLog(AndroidScanner.class);
    private final Context context;
    private final ClassLoader classLoader;
    private final Charset encoding;
    private final Location location;

    public AndroidScanner(ClassLoader classLoader, Charset encoding, Location location) {
        this.classLoader = classLoader;
        this.encoding = encoding;
        this.location = location;
        this.context = ContextHolder.getContext();
        if (this.context == null) {
            throw new FlywayException("Unable to scan for Migrations! Context not set. Within an activity you can fix this with org.flywaydb.core.api.android.ContextHolder.setContext(this);");
        }
    }

    @Override
    public Collection<LoadableResource> scanForResources() {
        ArrayList<LoadableResource> resources = new ArrayList<LoadableResource>();
        String path = this.location.getPath();
        try {
            for (String asset : this.context.getAssets().list(path)) {
                resources.add(new AndroidResource(this.location, this.context.getAssets(), path, asset, this.encoding));
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to scan for resources: " + e.getMessage());
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Class<?>> scanForClasses() {
        String pkg = this.location.getPath().replace("/", ".");
        ArrayList classes = new ArrayList();
        String sourceDir = this.context.getApplicationInfo().sourceDir;
        DexFile dex = null;
        try {
            dex = new DexFile(sourceDir);
            Enumeration entries = dex.entries();
            while (entries.hasMoreElements()) {
                Class<?> clazz;
                String className = (String)entries.nextElement();
                if (!className.startsWith(pkg) || (clazz = ClassUtils.loadClass(className, this.classLoader)) == null) continue;
                classes.add(clazz);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to scan DEX file (" + sourceDir + "): " + e.getMessage());
        }
        finally {
            if (dex != null) {
                try {
                    dex.close();
                }
                catch (IOException e) {
                    LOG.debug("Unable to close DEX file (" + sourceDir + "): " + e.getMessage());
                }
            }
        }
        return classes;
    }
}

