/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;

public class DbBaseline {
    private static final Log LOG = LogFactory.getLog(DbBaseline.class);
    private final SchemaHistory schemaHistory;
    private final MigrationVersion baselineVersion;
    private final String baselineDescription;
    private final CallbackExecutor callbackExecutor;

    public DbBaseline(SchemaHistory schemaHistory, MigrationVersion baselineVersion, String baselineDescription, CallbackExecutor callbackExecutor) {
        this.schemaHistory = schemaHistory;
        this.baselineVersion = baselineVersion;
        this.baselineDescription = baselineDescription;
        this.callbackExecutor = callbackExecutor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void baseline() {
        this.callbackExecutor.onEvent(Event.BEFORE_BASELINE);
        try {
            if (!this.schemaHistory.exists()) {
                this.schemaHistory.create(true);
            } else {
                AppliedMigration baselineMarker = this.schemaHistory.getBaselineMarker();
                if (baselineMarker != null) {
                    if (!this.baselineVersion.equals(baselineMarker.getVersion()) || !this.baselineDescription.equals(baselineMarker.getDescription())) throw new FlywayException("Unable to baseline schema history table " + this.schemaHistory + " with (" + this.baselineVersion + "," + this.baselineDescription + ") as it has already been baselined with (" + baselineMarker.getVersion() + "," + baselineMarker.getDescription() + ")");
                    LOG.info("Schema history table " + this.schemaHistory + " already initialized with (" + this.baselineVersion + "," + this.baselineDescription + "). Skipping.");
                } else {
                    if (this.schemaHistory.hasSchemasMarker() && this.baselineVersion.equals(MigrationVersion.fromVersion("0"))) {
                        throw new FlywayException("Unable to baseline schema history table " + this.schemaHistory + " with version 0 as this version was used for schema creation");
                    }
                    if (this.schemaHistory.hasNonSyntheticAppliedMigrations()) {
                        throw new FlywayException("Unable to baseline schema history table " + this.schemaHistory + " as it already contains migrations");
                    }
                }
            }
        }
        catch (FlywayException e) {
            this.callbackExecutor.onEvent(Event.AFTER_BASELINE_ERROR);
            throw e;
        }
        LOG.info("Successfully baselined schema with version: " + this.baselineVersion);
        this.callbackExecutor.onEvent(Event.AFTER_BASELINE);
    }
}

