/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resolver.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resolver.Context;
import org.flywaydb.core.api.resolver.MigrationResolver;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.resolver.ResolvedMigrationComparator;
import org.flywaydb.core.internal.resolver.ResolvedMigrationImpl;
import org.flywaydb.core.internal.resolver.sql.SqlMigrationExecutor;
import org.flywaydb.core.internal.resource.LoadableResource;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.resource.ResourceNameParser;
import org.flywaydb.core.internal.resource.ResourceProvider;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutorFactory;
import org.flywaydb.core.internal.sqlscript.SqlScriptFactory;

public class SqlMigrationResolver
implements MigrationResolver {
    private final SqlScriptExecutorFactory sqlScriptExecutorFactory;
    private final ResourceProvider resourceProvider;
    private final SqlScriptFactory sqlScriptFactory;
    private final Configuration configuration;

    public SqlMigrationResolver(ResourceProvider resourceProvider, SqlScriptExecutorFactory sqlScriptExecutorFactory, SqlScriptFactory sqlScriptFactory, Configuration configuration) {
        this.sqlScriptExecutorFactory = sqlScriptExecutorFactory;
        this.resourceProvider = resourceProvider;
        this.sqlScriptFactory = sqlScriptFactory;
        this.configuration = configuration;
    }

    public List<ResolvedMigration> resolveMigrations(Context context) {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        String separator = this.configuration.getSqlMigrationSeparator();
        String[] suffixes = this.configuration.getSqlMigrationSuffixes();
        this.addMigrations(migrations, this.configuration.getSqlMigrationPrefix(), separator, suffixes, false);
        this.addMigrations(migrations, this.configuration.getRepeatableSqlMigrationPrefix(), separator, suffixes, true);
        Collections.sort(migrations, new ResolvedMigrationComparator());
        return migrations;
    }

    private void addMigrations(List<ResolvedMigration> migrations, String prefix, String separator, String[] suffixes, boolean repeatable) {
        ResourceNameParser resourceNameParser = new ResourceNameParser(this.configuration);
        for (LoadableResource resource : this.resourceProvider.getResources(prefix, suffixes)) {
            String filename = resource.getFilename();
            ResourceName result = resourceNameParser.parse(filename);
            if (!result.isValid() || SqlMigrationResolver.isSqlCallback(result)) continue;
            SqlScript sqlScript = this.sqlScriptFactory.createSqlScript(resource, this.configuration.isMixed(), this.resourceProvider);
            int checksum = resource.checksum();
            migrations.add(new ResolvedMigrationImpl(result.getVersion(), result.getDescription(), resource.getRelativePath(), checksum, MigrationType.SQL, resource.getAbsolutePathOnDisk(), new SqlMigrationExecutor(this.sqlScriptExecutorFactory, sqlScript)){

                @Override
                public void validate() {
                }
            });
        }
    }

    static boolean isSqlCallback(ResourceName result) {
        return Event.fromId(result.getPrefix()) != null;
    }
}

