/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.SQLException;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBRetryingStrategy;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBSchema;
import org.flywaydb.core.internal.database.cockroachdb.RandomStringGenerator;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.util.SqlCallable;

public class CockroachDBTable
extends Table<CockroachDBDatabase, CockroachDBSchema> {
    private static final Log LOG = LogFactory.getLog(CockroachDBTable.class);
    private String tableLockString = RandomStringGenerator.getNextRandomString();

    CockroachDBTable(JdbcTemplate jdbcTemplate, CockroachDBDatabase database, CockroachDBSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
    }

    @Override
    protected void doDrop() throws SQLException {
        new CockroachDBRetryingStrategy().execute(new SqlCallable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                CockroachDBTable.this.doDropOnce();
                return null;
            }
        });
    }

    protected void doDropOnce() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + ((CockroachDBDatabase)this.database).quote(((CockroachDBSchema)this.schema).getName(), this.name) + " CASCADE", new Object[0]);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return new CockroachDBRetryingStrategy().execute(new SqlCallable<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                return CockroachDBTable.this.doExistsOnce();
            }
        });
    }

    protected boolean doExistsOnce() throws SQLException {
        if (((CockroachDBSchema)this.schema).cockroachDB1) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_schema = ?\n   AND    table_name = ?\n)", ((CockroachDBSchema)this.schema).getName(), this.name);
        }
        return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_catalog = ?\n   AND    table_schema = 'public'\n   AND    table_name = ?\n)", ((CockroachDBSchema)this.schema).getName(), this.name);
    }

    @Override
    protected void doLock() throws SQLException {
        if (this.lockDepth > 0) {
            return;
        }
        int retryCount = 0;
        do {
            try {
                if (this.insertLockingRow()) {
                    return;
                }
                ++retryCount;
                LOG.debug("Waiting for lock on " + this);
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (retryCount < 50);
        throw new FlywayException("Unable to obtain table lock - another Flyway instance may be running");
    }

    private boolean insertLockingRow() {
        Results results = this.jdbcTemplate.executeStatement("INSERT INTO " + this + " VALUES (-100, '" + this.tableLockString + "', 'flyway-lock', '', '', 0, '', now(), 0, TRUE)");
        return results.getResults().size() > 0 && results.getResults().get(0).getUpdateCount() == 1L && results.getErrors().size() == 0;
    }

    @Override
    protected void doUnlock() throws SQLException {
        if (this.lockDepth > 1) {
            return;
        }
        int competingLocksTaken = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this + " WHERE version != '" + this.tableLockString + "' AND DESCRIPTION = 'flyway-lock'", new String[0]);
        if (competingLocksTaken > 0) {
            throw new FlywayException("Internal error: on unlocking, a competing lock was found");
        }
        this.jdbcTemplate.executeStatement("DELETE FROM " + this + " WHERE version = '" + this.tableLockString + "' AND DESCRIPTION = 'flyway-lock'");
    }
}

