/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Random;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;

public class InsertRowLock {
    private static final Log LOG = LogFactory.getLog(InsertRowLock.class);
    private static final Random random = new Random();
    private final String tableLockString = this.getNextRandomString();

    public void doLock(JdbcTemplate jdbcTemplate, String insertStatementTemplate, String booleanTrue) throws SQLException {
        int retryCount = 0;
        while (true) {
            try {
                while (true) {
                    if (this.insertLockingRow(jdbcTemplate, insertStatementTemplate, booleanTrue)) {
                        return;
                    }
                    if (retryCount < 50) {
                        ++retryCount;
                        LOG.debug("Waiting for lock on " + this);
                    } else {
                        LOG.error("Waiting for lock on " + this + ". Application may be deadlocked. Lock row may require manual removal from the schema history table.");
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private boolean insertLockingRow(JdbcTemplate jdbcTemplate, String insertStatementTemplate, String booleanTrue) {
        String insertStatement = String.format(insertStatementTemplate.replace("?", "%s"), -100, "'" + this.tableLockString + "'", "'flyway-lock'", "''", "''", 0, "''", 0, booleanTrue);
        Results results = jdbcTemplate.executeStatement(insertStatement);
        return results.getException() == null;
    }

    public void doUnlock(JdbcTemplate jdbcTemplate, String deleteLockTemplate) throws SQLException {
        String deleteLock = String.format(deleteLockTemplate.replace("?", "%s"), this.tableLockString);
        jdbcTemplate.executeStatement(deleteLock);
    }

    private String getNextRandomString() {
        BigInteger bInt = new BigInteger(128, random);
        return bInt.toString(16);
    }
}

