/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.util;

import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.internal.license.VersionPrinter;

public class LinkUtils {
    public static String createFlywayDbWebsiteLinkWithRef(String ref, String ... pathParts) {
        String link = LinkUtils.createFlywayDbWebsiteLink(pathParts);
        link = link.contains("?ref=v") ? link + "_" + ref : link + "?ref=" + ref;
        return link;
    }

    public static String createFlywayDbWebsiteLink(String ... pathParts) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://flywaydb.org/");
        for (String pathPart : pathParts) {
            stringBuilder.append(pathPart).append("/");
        }
        try {
            MigrationVersion current = MigrationVersion.fromVersion(VersionPrinter.getVersion());
            stringBuilder.append("?ref=v").append(current);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuilder.toString();
    }
}

