/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal;

import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.ClassUtils;

public class FlywayTeamsObjectResolver {
    private static final Log LOG = LogFactory.getLog(FlywayTeamsObjectResolver.class);

    public static <T> T resolve(Class<T> clazz, Object ... params) {
        String packageName = clazz.getPackage().getName();
        String className = clazz.getSimpleName();
        ClassLoader classLoader = new FlywayTeamsObjectResolver().getClass().getClassLoader();
        if (VersionPrinter.EDITION != Edition.COMMUNITY) {
            String teamsPath = packageName + ".teams." + className;
            try {
                return ClassUtils.instantiate(teamsPath, classLoader, params);
            }
            catch (FlywayException ignored) {
                LOG.debug("Could not load " + teamsPath + ". Defaulting to Community Edition for " + className);
            }
        }
        return ClassUtils.instantiate(packageName + "." + className, classLoader, params);
    }

    private FlywayTeamsObjectResolver() {
    }
}

