/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.cubrid;

import java.sql.Connection;
import org.flywaydb.community.database.cubrid.CubridConnection;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;

public class CubridDatabase
extends Database<CubridConnection> {
    private static final Log LOG = LogFactory.getLog(CubridDatabase.class);

    public CubridDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected CubridConnection doGetConnection(Connection connection) {
        return new CubridConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
    }

    public boolean supportsDdlTransactions() {
        return false;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public boolean catalogIsSchema() {
        return false;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        return "CREATE TABLE IF NOT EXISTS " + String.valueOf(table) + " (\n    \"installed_rank\" INT NOT NULL PRIMARY KEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INT,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP NOT NULL DEFAULT NOW(),\n    \"execution_time\" INT NOT NULL,\n    \"success\" INT NOT NULL\n);\n" + (String)(baseline ? this.getBaselineStatement(table) + ";\n" : "") + "CREATE INDEX " + table.getName() + "_s_idx ON " + String.valueOf(table) + " (\"success\");";
    }

    public boolean useSingleConnection() {
        return false;
    }
}

