/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.cubrid;

import java.sql.Connection;
import org.flywaydb.community.database.CubridDatabaseExtension;
import org.flywaydb.community.database.cubrid.CubridConnection;
import org.flywaydb.community.database.cubrid.CubridDatabase;
import org.flywaydb.community.database.cubrid.CubridParser;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.CommunityDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;

public class CubridDatabaseType
extends BaseDatabaseType
implements CommunityDatabaseType {
    public String getName() {
        return "CUBRID";
    }

    public int getNullType() {
        return 0;
    }

    public boolean handlesJDBCUrl(String url) {
        return url.startsWith("jdbc:cubrid:");
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return "cubrid.jdbc.driver.CUBRIDDriver";
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName != null && databaseProductName.trim().toLowerCase().contains("cubrid");
    }

    public Database<CubridConnection> createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new CubridDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new CubridParser(configuration, parsingContext);
    }

    public String getPluginVersion(Configuration config) {
        return CubridDatabaseExtension.readVersion();
    }
}

