/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.duckdb;

import java.sql.SQLException;
import java.util.List;
import org.flywaydb.community.database.duckdb.DuckDBDatabase;
import org.flywaydb.community.database.duckdb.DuckDBTable;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class DuckDBSchema
extends Schema<DuckDBDatabase, DuckDBTable> {
    public DuckDBSchema(JdbcTemplate jdbcTemplate, DuckDBDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        String countSchemasWithName = "SELECT COUNT(*) FROM information_schema.schemata WHERE schema_name = ?";
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM information_schema.schemata WHERE schema_name = ?", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() throws SQLException {
        String countTablesInSchema = "SELECT count(*) from information_schema.tables WHERE table_schema = ?";
        return this.jdbcTemplate.queryForInt("SELECT count(*) from information_schema.tables WHERE table_schema = ?", new String[]{this.name}) == 0;
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((DuckDBDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((DuckDBDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doClean() throws SQLException {
        this.dropAll("MACRO", this.getAllMacros());
        this.dropAll("SEQUENCE", this.getAllObjectsNames("sequence_name", "duckdb_sequences()"));
        this.dropAll("VIEW", this.getAllViews());
        List<Table> tables = this.getAllTables();
        while (!tables.isEmpty()) {
            List<String> tablesWithoutIncomingRefs = tables.stream().filter(table -> table.incomingRefsCount == 0).map(table -> table.tableName).toList();
            if (tablesWithoutIncomingRefs.isEmpty()) {
                throw new IllegalStateException("Cannot drop all tables in schema %s.\nDuckdb does not support DROP TABLE if the table has incoming references.\nAll existing tables have such references.\n".formatted(this.name));
            }
            this.dropAll("TABLE", tablesWithoutIncomingRefs);
            tables = this.getAllTables();
        }
    }

    protected DuckDBTable[] doAllTables() throws SQLException {
        return this.getAllTables().stream().map(table -> table.tableName).map(this::getTable).toList().toArray(new DuckDBTable[0]);
    }

    public DuckDBTable getTable(String tableName) {
        return new DuckDBTable(this.jdbcTemplate, (DuckDBDatabase)this.database, this, tableName);
    }

    private void dropAll(String objectType, List<String> objectsNames) throws SQLException {
        for (String objectName : objectsNames) {
            this.jdbcTemplate.execute("DROP %s %s.%s CASCADE".formatted(objectType, ((DuckDBDatabase)this.database).quote(new String[]{this.name}), ((DuckDBDatabase)this.database).quote(new String[]{objectName})), new Object[0]);
        }
    }

    private List<String> getAllMacros() throws SQLException {
        String sql = "SELECT function_name FROM duckdb_functions() WHERE NOT internal AND schema_name = ?";
        return this.jdbcTemplate.queryForStringList("SELECT function_name FROM duckdb_functions() WHERE NOT internal AND schema_name = ?", new String[]{this.name});
    }

    private List<String> getAllViews() throws SQLException {
        String sql = "SELECT view_name FROM duckdb_views() WHERE NOT internal AND schema_name = ?";
        return this.jdbcTemplate.queryForStringList("SELECT view_name FROM duckdb_views() WHERE NOT internal AND schema_name = ?", new String[]{this.name});
    }

    private List<Table> getAllTables() throws SQLException {
        String sql = "    SELECT\n        table_name,\n        (\n            SELECT count(*)\n            FROM information_schema.referential_constraints rc\n            JOIN information_schema.key_column_usage to_column_usage\n                ON rc.unique_constraint_name = to_column_usage.constraint_name\n                AND rc.unique_constraint_schema = to_column_usage.constraint_schema\n            JOIN information_schema.key_column_usage from_column_usage\n                ON rc.constraint_name = from_column_usage.constraint_name\n                AND rc.constraint_schema = from_column_usage.constraint_schema\n            WHERE to_column_usage.constraint_schema = ?\n                AND to_column_usage.table_name = tbls.table_name\n                AND from_column_usage.table_name != tbls.table_name\n        ) AS incoming_refs_count\n    FROM duckdb_tables() tbls\n    WHERE tbls.schema_name = ?;\n";
        return this.jdbcTemplate.query("    SELECT\n        table_name,\n        (\n            SELECT count(*)\n            FROM information_schema.referential_constraints rc\n            JOIN information_schema.key_column_usage to_column_usage\n                ON rc.unique_constraint_name = to_column_usage.constraint_name\n                AND rc.unique_constraint_schema = to_column_usage.constraint_schema\n            JOIN information_schema.key_column_usage from_column_usage\n                ON rc.constraint_name = from_column_usage.constraint_name\n                AND rc.constraint_schema = from_column_usage.constraint_schema\n            WHERE to_column_usage.constraint_schema = ?\n                AND to_column_usage.table_name = tbls.table_name\n                AND from_column_usage.table_name != tbls.table_name\n        ) AS incoming_refs_count\n    FROM duckdb_tables() tbls\n    WHERE tbls.schema_name = ?;\n", rs -> new Table(rs.getString("table_name"), rs.getInt("incoming_refs_count")), new Object[]{this.name, this.name});
    }

    private List<String> getAllObjectsNames(String catalogNameField, String catalogTable) throws SQLException {
        String sql = "SELECT %s FROM %s WHERE schema_name = ?".formatted(catalogNameField, catalogTable);
        return this.jdbcTemplate.queryForStringList(sql, new String[]{this.name});
    }

    private record Table(String tableName, int incomingRefsCount) {
    }
}

