/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.timeplus;

import java.sql.SQLException;
import org.flywaydb.community.database.timeplus.TimeplusConnection;
import org.flywaydb.community.database.timeplus.TimeplusDatabase;
import org.flywaydb.community.database.timeplus.TimeplusSchema;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.StringUtils;

public class TimeplusTable
extends Table<TimeplusDatabase, TimeplusSchema> {
    private static final Log LOG = LogFactory.getLog(TimeplusTable.class);

    public TimeplusTable(JdbcTemplate jdbcTemplate, TimeplusDatabase database, TimeplusSchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
    }

    protected void doDrop() throws SQLException {
        String clusterName = ((TimeplusDatabase)this.database).getClusterName();
        this.jdbcTemplate.executeStatement("DROP STREAM " + String.valueOf((Object)this) + (String)(StringUtils.hasText((String)clusterName) ? " ON CLUSTER " + clusterName : ""));
    }

    protected boolean doExists() throws SQLException {
        TimeplusConnection systemConnection = ((TimeplusDatabase)this.database).getSystemConnection();
        int count = systemConnection.getJdbcTemplate().queryForInt("SELECT COUNT() FROM system.tables WHERE database = ? AND name = ?", new String[]{((TimeplusSchema)this.schema).getName(), this.name});
        return count > 0;
    }

    protected void doLock() throws SQLException {
        LOG.debug("Unable to lock " + String.valueOf((Object)this) + " as Timeplus does not support locking. No concurrent migration supported.");
    }
}

