/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.database.firebird;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.database.firebird.FirebirdConnection;

public class FirebirdDatabase
extends Database<FirebirdConnection> {
    public FirebirdDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        super(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    protected FirebirdConnection doGetConnection(Connection connection) {
        return new FirebirdConnection(this, connection);
    }

    public void ensureSupported(Configuration configuration) {
        this.ensureDatabaseIsRecentEnough("3.0");
    }

    public boolean supportsDdlTransactions() {
        return true;
    }

    public String getBooleanTrue() {
        return "1";
    }

    public String getBooleanFalse() {
        return "0";
    }

    public String doQuote(String identifier) {
        return this.getOpenQuote() + identifier.replace(this.getCloseQuote(), this.getEscapedQuote()) + this.getCloseQuote();
    }

    public String getEscapedQuote() {
        return "\"\"";
    }

    public boolean catalogIsSchema() {
        return true;
    }

    public String getRawCreateScript(Table table, boolean baseline) {
        String createScript = "CREATE TABLE " + table + " (\n    \"installed_rank\" INTEGER CONSTRAINT \"" + table.getName() + "_pk\" PRIMARY KEY,\n    \"version\" VARCHAR(50),\n    \"description\" VARCHAR(200) NOT NULL,\n    \"type\" VARCHAR(20) NOT NULL,\n    \"script\" VARCHAR(1000) NOT NULL,\n    \"checksum\" INTEGER,\n    \"installed_by\" VARCHAR(100) NOT NULL,\n    \"installed_on\" TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL,\n    \"execution_time\" INTEGER NOT NULL,\n    \"success\" SMALLINT NOT NULL\n);\nCREATE INDEX \"" + table.getName() + "_s_idx\" ON " + table + " (\"success\");\n";
        if (baseline) {
            createScript = createScript + "COMMIT RETAIN;\n" + this.getBaselineStatement(table) + ";\n";
        }
        return createScript;
    }

    protected String doGetCurrentUser() throws SQLException {
        return ((FirebirdConnection)this.getMainConnection()).getJdbcTemplate().queryForString("select CURRENT_USER from RDB$DATABASE", new String[0]);
    }

    public boolean useSingleConnection() {
        return true;
    }
}

