/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.reports.output;

import java.util.List;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.internal.util.CollectionsUtils;
import org.flywaydb.reports.api.extensibility.HtmlRenderer;
import org.flywaydb.reports.api.extensibility.HtmlReportSummary;
import org.flywaydb.reports.html.HtmlReportGenerator;
import org.flywaydb.reports.output.DashboardResult;
import org.flywaydb.reports.utils.HtmlUtils;

public class DashboardRenderer
implements HtmlRenderer<DashboardResult> {
    @Override
    public String render(DashboardResult result, Configuration config) {
        StringBuilder html = new StringBuilder("<div class='dashboardContainer'>");
        int tabCount = 1;
        for (HtmlResult htmlResult : result.getResults()) {
            if (htmlResult instanceof DashboardResult) continue;
            HtmlRenderer<HtmlResult> resultRenderer = HtmlReportGenerator.getRenderer(htmlResult, config);
            List<HtmlReportSummary> summaries = resultRenderer.getHtmlSummary(htmlResult, config);
            if (CollectionsUtils.hasItems(summaries)) {
                List<HtmlReportSummary> filteredSummaries = summaries.stream().filter(x -> !x.getCssClass().contains("summaryNote")).toList();
                html.append("<div class='dashboardSummaryGroup'>");
                html.append("<h5>").append(resultRenderer.tabTitle(htmlResult, config)).append("</h5>");
                for (HtmlReportSummary s : filteredSummaries) {
                    html.append("<div class='summaryDiv ").append(s.getCssClass()).append("'><div class='summaryDivContent'><span class='summaryIcon'><svg fill=\"none\"><use href=\"#").append(s.getIcon()).append("\"/></svg></span><span class='summaryText'>").append(s.getSummaryText()).append("</span></div></div>");
                }
                String id2 = htmlResult.getOperation() + "-" + tabCount + "_" + HtmlUtils.getFormattedTimestamp(htmlResult);
                html.append("<button class='clickable inspectButton fancyButton' onclick=\"onTabClick(event, '").append(HtmlReportGenerator.getTabId(htmlResult, config, tabCount)).append("','").append(id2).append("')\">Inspect ").append(resultRenderer.tabTitle(htmlResult, config)).append("</button>");
                html.append("</div>");
            }
            ++tabCount;
        }
        html.append("</div>");
        return html.toString();
    }

    @Override
    public String tabTitle(DashboardResult result, Configuration config) {
        return "Dashboard";
    }

    @Override
    public Class<DashboardResult> getType() {
        return DashboardResult.class;
    }
}

