/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.reports.utils;

import java.io.File;
import java.io.FileWriter;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.commons.text.StringEscapeUtils;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.CompositeResult;
import org.flywaydb.core.api.output.HtmlResult;
import org.flywaydb.core.internal.util.FileUtils;
import org.flywaydb.reports.html.HtmlReportGenerator;

public class HtmlUtils {
    public static String toHtmlFile(String filename, CompositeResult<? extends HtmlResult> results, Configuration config) {
        String string;
        String fileContents = HtmlReportGenerator.generateHtml(results, config);
        File file = new File(filename);
        FileUtils.createDirIfNotExists((File)file);
        FileWriter fileWriter = new FileWriter(file);
        try {
            fileWriter.write(fileContents);
            string = file.getCanonicalPath();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new FlywayException("Unable to write HTML to file: " + e.getMessage(), (Throwable)e);
            }
        }
        fileWriter.close();
        return string;
    }

    public static String getFormattedTimestamp(HtmlResult result) {
        if (result == null || result.getTimestamp() == null) {
            return "--";
        }
        return result.getTimestamp().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT));
    }

    public static String htmlEncode(String input) {
        return StringEscapeUtils.escapeHtml4((String)input);
    }
}

