/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.verb.migrate.migrators;

import org.flywaydb.core.internal.nc.ConnectionType;
import org.flywaydb.core.internal.nc.NativeConnectorsDatabase;
import org.flywaydb.nc.NativeConnectorsHybrid;
import org.flywaydb.verb.migrate.migrators.ApiMigrator;
import org.flywaydb.verb.migrate.migrators.ExecutableMigrator;
import org.flywaydb.verb.migrate.migrators.HybridMigrator;
import org.flywaydb.verb.migrate.migrators.JdbcMigrator;
import org.flywaydb.verb.migrate.migrators.Migrator;

public class MigratorFactory {
    public static <DB extends NativeConnectorsDatabase> Migrator getMigrator(DB database) {
        if (database instanceof NativeConnectorsHybrid) {
            return new HybridMigrator();
        }
        return switch (database.getDatabaseMetaData().connectionType()) {
            default -> throw new IncompatibleClassChangeError();
            case ConnectionType.API -> new ApiMigrator();
            case ConnectionType.JDBC -> new JdbcMigrator();
            case ConnectionType.EXECUTABLE -> new ExecutableMigrator();
        };
    }
}

