/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import javafx.beans.property.BooleanProperty;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.model.StyleSpans;

public interface StyleActions<PS, S> {
    default public boolean getUseInitialStyleForInsertion() {
        return this.useInitialStyleForInsertionProperty().get();
    }

    default public void setUseInitialStyleForInsertion(boolean value) {
        this.useInitialStyleForInsertionProperty().set(value);
    }

    public BooleanProperty useInitialStyleForInsertionProperty();

    public S getInitialTextStyle();

    public PS getInitialParagraphStyle();

    public S getTextStyleForInsertionAt(int var1);

    public PS getParagraphStyleForInsertionAt(int var1);

    public boolean isPreserveStyle();

    public S getStyleOfChar(int var1);

    public S getStyleAtPosition(int var1);

    public IndexRange getStyleRangeAtPosition(int var1);

    public StyleSpans<S> getStyleSpans(int var1, int var2);

    default public StyleSpans<S> getStyleSpans(IndexRange range) {
        return this.getStyleSpans(range.getStart(), range.getEnd());
    }

    public S getStyleOfChar(int var1, int var2);

    public S getStyleAtPosition(int var1, int var2);

    public IndexRange getStyleRangeAtPosition(int var1, int var2);

    public StyleSpans<S> getStyleSpans(int var1);

    public StyleSpans<S> getStyleSpans(int var1, int var2, int var3);

    default public StyleSpans<S> getStyleSpans(int paragraph, IndexRange range) {
        return this.getStyleSpans(paragraph, range.getStart(), range.getStart());
    }

    public void setStyle(int var1, int var2, S var3);

    public void setStyle(int var1, S var2);

    public void setStyle(int var1, int var2, int var3, S var4);

    public void setStyleSpans(int var1, StyleSpans<? extends S> var2);

    public void setStyleSpans(int var1, int var2, StyleSpans<? extends S> var3);

    public void setParagraphStyle(int var1, PS var2);

    default public void clearStyle(int from, int to) {
        this.setStyle(from, to, this.getInitialTextStyle());
    }

    default public void clearStyle(int paragraph, int from, int to) {
        this.setStyle(paragraph, from, to, this.getInitialTextStyle());
    }

    default public void clearStyle(int paragraph) {
        this.setStyle(paragraph, this.getInitialTextStyle());
    }

    default public void clearParagraphStyle(int paragraph) {
        this.setParagraphStyle(paragraph, this.getInitialParagraphStyle());
    }
}

