/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.scene.control.IndexRange;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpan;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;

public final class Paragraph<PS, SEG, S> {
    private final List<SEG> segments;
    private final StyleSpans<S> styles;
    private final TwoLevelNavigator navigator;
    private final PS paragraphStyle;
    private final SegmentOps<SEG, S> segmentOps;
    private List<StyledSegment<SEG, S>> styledSegments = null;
    private int length = -1;
    private String text = null;

    private static <SEG, S> Tuple2<List<SEG>, StyleSpans<S>> decompose(List<StyledSegment<SEG, S>> list, SegmentOps<SEG, S> segmentOps) {
        ArrayList<SEG> segs = new ArrayList<SEG>();
        StyleSpansBuilder<S> builder = new StyleSpansBuilder<S>();
        for (StyledSegment<SEG, S> styledSegment : list) {
            if (segs.isEmpty()) {
                segs.add(styledSegment.getSegment());
            } else {
                int lastIndex = segs.size() - 1;
                Object previousSeg = segs.get(lastIndex);
                Optional<SEG> merged = segmentOps.joinSeg(previousSeg, styledSegment.getSegment());
                if (merged.isPresent()) {
                    segs.set(lastIndex, merged.get());
                } else {
                    segs.add(styledSegment.getSegment());
                }
            }
            builder.add(styledSegment.getStyle(), segmentOps.length(styledSegment.getSegment()));
        }
        return Tuples.t(segs, builder.create());
    }

    @SafeVarargs
    private static <T> List<T> list(T head, T ... tail) {
        if (tail.length == 0) {
            return Collections.singletonList(head);
        }
        ArrayList<T> list = new ArrayList<T>(1 + tail.length);
        list.add(head);
        Collections.addAll(list, tail);
        return list;
    }

    public Paragraph(PS paragraphStyle, SegmentOps<SEG, S> segmentOps, List<StyledSegment<SEG, S>> styledSegments) {
        this(paragraphStyle, segmentOps, Paragraph.decompose(styledSegments, segmentOps));
    }

    private Paragraph(PS paragraphStyle, SegmentOps<SEG, S> segmentOps, Tuple2<List<SEG>, StyleSpans<S>> decomposedList) {
        this(paragraphStyle, segmentOps, (List)decomposedList._1, (StyleSpans)decomposedList._2);
    }

    public Paragraph(PS paragraphStyle, SegmentOps<SEG, S> segmentOps, SEG segment, S style) {
        this(paragraphStyle, segmentOps, segment, StyleSpans.singleton(style, segmentOps.length(segment)));
    }

    public Paragraph(PS paragraphStyle, SegmentOps<SEG, S> segmentOps, SEG segment, StyleSpans<S> styles) {
        this(paragraphStyle, segmentOps, Collections.singletonList(segment), styles);
    }

    public Paragraph(PS paragraphStyle, SegmentOps<SEG, S> segmentOps, List<SEG> segments, StyleSpans<S> styles) {
        if (segments.isEmpty()) {
            throw new IllegalArgumentException("Cannot construct a Paragraph with an empty list of segments");
        }
        if (styles.getSpanCount() == 0) {
            throw new IllegalArgumentException("Cannot construct a Paragraph with StyleSpans object that contains no StyleSpan objects");
        }
        this.segmentOps = segmentOps;
        this.segments = segments;
        this.styles = styles;
        this.paragraphStyle = paragraphStyle;
        this.navigator = new TwoLevelNavigator(segments::size, i -> segmentOps.length(segments.get(i)));
    }

    public List<StyledSegment<SEG, S>> getStyledSegments() {
        if (this.styledSegments == null) {
            this.styledSegments = this.segments.size() == 1 && this.styles.getSpanCount() == 1 ? Collections.singletonList(new StyledSegment<SEG, S>(this.segments.get(0), this.styles.getStyleSpan(0).getStyle())) : this.createStyledSegments();
        }
        return this.styledSegments;
    }

    public List<SEG> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public PS getParagraphStyle() {
        return this.paragraphStyle;
    }

    public int length() {
        if (this.length == -1) {
            this.length = this.segments.stream().mapToInt(this.segmentOps::length).sum();
        }
        return this.length;
    }

    public char charAt(int index) {
        TwoDimensional.Position pos = this.navigator.offsetToPosition(index, TwoDimensional.Bias.Forward);
        return this.segmentOps.charAt(this.segments.get(pos.getMajor()), pos.getMinor());
    }

    public String substring(int from, int to) {
        return this.getText().substring(from, Math.min(to, this.length()));
    }

    public String substring(int from) {
        return this.getText().substring(from);
    }

    public Paragraph<PS, SEG, S> concat(Paragraph<PS, SEG, S> p) {
        StyleSpans<S> updatedStyles;
        ArrayList<SEG> updatedSegs;
        SEG rightSeg;
        if (p.length() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return p;
        }
        SEG leftSeg = this.segments.get(this.segments.size() - 1);
        Optional<SEG> joined = this.segmentOps.joinSeg(leftSeg, rightSeg = p.segments.get(0));
        if (joined.isPresent()) {
            SEG segment = joined.get();
            updatedSegs = new ArrayList(this.segments.size() + p.segments.size() - 1);
            updatedSegs.addAll(this.segments.subList(0, this.segments.size() - 1));
            updatedSegs.add(segment);
            updatedSegs.addAll(p.segments.subList(1, p.segments.size()));
        } else {
            updatedSegs = new ArrayList<SEG>(this.segments.size() + p.segments.size());
            updatedSegs.addAll(this.segments);
            updatedSegs.addAll(p.segments);
        }
        StyleSpan<S> leftSpan = this.styles.getStyleSpan(this.styles.getSpanCount() - 1);
        StyleSpan<S> rightSpan = p.styles.getStyleSpan(0);
        Optional<S> merge = this.segmentOps.joinStyle(leftSpan.getStyle(), rightSpan.getStyle());
        if (merge.isPresent()) {
            int startOfMerge = this.styles.position(this.styles.getSpanCount() - 1, 0).toOffset();
            StyleSpans<S> updatedLeftSpan = this.styles.subView(0, startOfMerge);
            int endOfMerge = p.styles.position(1, 0).toOffset();
            StyleSpans<S> updatedRightSpan = p.styles.subView(endOfMerge, p.styles.length());
            updatedStyles = updatedLeftSpan.append(merge.get(), leftSpan.getLength() + rightSpan.getLength()).concat(updatedRightSpan);
        } else {
            updatedStyles = this.styles.concat(p.styles);
        }
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, updatedSegs, updatedStyles);
    }

    Paragraph<PS, SEG, S> concatR(Paragraph<PS, SEG, S> that) {
        return this.length() == 0 && that.length() == 0 ? that : this.concat(that);
    }

    public Paragraph<PS, SEG, S> subSequence(int start, int end) {
        return this.trim(end).subSequence(start);
    }

    public Paragraph<PS, SEG, S> trim(int length) {
        if (length >= this.length()) {
            return this;
        }
        TwoDimensional.Position pos = this.navigator.offsetToPosition(length, TwoDimensional.Bias.Backward);
        int segIdx = pos.getMajor();
        ArrayList<SEG> segs = new ArrayList<SEG>(segIdx + 1);
        segs.addAll(this.segments.subList(0, segIdx));
        segs.add(this.segmentOps.subSequence(this.segments.get(segIdx), 0, pos.getMinor()));
        if (segs.isEmpty()) {
            segs.add(this.segmentOps.createEmptySeg());
        }
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, segs, this.styles.subView(0, length));
    }

    public Paragraph<PS, SEG, S> subSequence(int start) {
        if (start < 0) {
            throw new IllegalArgumentException("start must not be negative (was: " + start + ")");
        }
        if (start == 0) {
            return this;
        }
        if (start == this.length()) {
            return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, this.segmentOps.createEmptySeg(), this.styles.subView(start, start));
        }
        if (start < this.length()) {
            TwoDimensional.Position pos = this.navigator.offsetToPosition(start, TwoDimensional.Bias.Forward);
            int segIdx = pos.getMajor();
            ArrayList<SEG> segs = new ArrayList<SEG>(this.segments.size() - segIdx);
            segs.add(this.segmentOps.subSequence(this.segments.get(segIdx), pos.getMinor()));
            segs.addAll(this.segments.subList(segIdx + 1, this.segments.size()));
            if (segs.isEmpty()) {
                segs.add(this.segmentOps.createEmptySeg());
            }
            return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, segs, this.styles.subView(start, this.styles.length()));
        }
        throw new IndexOutOfBoundsException(start + " not in [0, " + this.length() + "]");
    }

    public Paragraph<PS, SEG, S> delete(int start, int end) {
        return this.trim(start).concat(this.subSequence(end));
    }

    public Paragraph<PS, SEG, S> restyle(S style) {
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, this.segments, StyleSpans.singleton(style, this.length()));
    }

    public Paragraph<PS, SEG, S> restyle(int from, int to, S style) {
        if (from >= this.length()) {
            return this;
        }
        StyleSpans<S> left = this.styles.subView(0, from);
        StyleSpans<S> right = this.styles.subView(to, this.length());
        StyleSpans<S> updatedStyles = left.append(style, to - from).concat(right);
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, this.segments, updatedStyles);
    }

    public Paragraph<PS, SEG, S> restyle(int from, StyleSpans<? extends S> styleSpans) {
        int len = styleSpans.length();
        if (styleSpans.equals(this.getStyleSpans(from, from + len)) || styleSpans.getSpanCount() == 0) {
            return this;
        }
        if (this.length() == 0) {
            return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, this.segments, styleSpans);
        }
        StyleSpans<S> left = this.styles.subView(0, from);
        StyleSpans<S> right = this.styles.subView(from + len, this.length());
        StyleSpans<S> castedSpans = styleSpans;
        StyleSpans<? extends S> updatedStyles = left.concat(castedSpans).concat(right);
        return new Paragraph<PS, SEG, S>(this.paragraphStyle, this.segmentOps, this.segments, updatedStyles);
    }

    public Paragraph<PS, SEG, S> setParagraphStyle(PS paragraphStyle) {
        return new Paragraph<PS, SEG, S>(paragraphStyle, this.segmentOps, this.segments, this.styles);
    }

    public S getStyleOfChar(int charIdx) {
        if (charIdx < 0) {
            return this.styles.getStyleSpan(0).getStyle();
        }
        TwoDimensional.Position pos = this.styles.offsetToPosition(charIdx, TwoDimensional.Bias.Forward);
        return this.styles.getStyleSpan(pos.getMajor()).getStyle();
    }

    public S getStyleAtPosition(int position) {
        if (position < 0) {
            throw new IllegalArgumentException("Paragraph position cannot be negative (" + position + ")");
        }
        TwoDimensional.Position pos = this.styles.offsetToPosition(position, TwoDimensional.Bias.Backward);
        return this.styles.getStyleSpan(pos.getMajor()).getStyle();
    }

    public IndexRange getStyleRangeAtPosition(int position) {
        TwoDimensional.Position pos = this.styles.offsetToPosition(position, TwoDimensional.Bias.Backward);
        int start = position - pos.getMinor();
        int end = start + this.styles.getStyleSpan(pos.getMajor()).getLength();
        return new IndexRange(start, end);
    }

    public StyleSpans<S> getStyleSpans() {
        return this.styles;
    }

    public StyleSpans<S> getStyleSpans(int from, int to) {
        return this.styles.subView(from, to);
    }

    public String getText() {
        if (this.text == null) {
            StringBuilder sb = new StringBuilder(this.length());
            for (SEG seg : this.segments) {
                sb.append(this.segmentOps.getText(seg));
            }
            this.text = sb.toString();
        }
        return this.text;
    }

    public String toString() {
        return "Par[" + this.paragraphStyle + "; " + this.getStyledSegments().stream().map(Object::toString).reduce((s1, s2) -> s1 + ", " + s2).orElse("") + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof Paragraph) {
            Paragraph that = (Paragraph)other;
            return Objects.equals(this.paragraphStyle, that.paragraphStyle) && Objects.equals(this.segments, that.segments) && Objects.equals(this.styles, that.styles);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.paragraphStyle, this.segments, this.styles);
    }

    private List<StyledSegment<SEG, S>> createStyledSegments() {
        LinkedList<StyledSegment<SEG, S>> styledSegments = new LinkedList<StyledSegment<SEG, S>>();
        Iterator<SEG> segIterator = this.segments.iterator();
        Iterator<StyleSpan<S>> styleIterator = this.styles.iterator();
        SEG segCurrent = segIterator.next();
        StyleSpan<S> styleCurrent = styleIterator.next();
        int segOffset = 0;
        int styleOffset = 0;
        boolean finished = false;
        while (!finished) {
            SEG splitSeg;
            int styleLength;
            int segLength = this.segmentOps.length(segCurrent) - segOffset;
            if (segLength < (styleLength = styleCurrent.getLength() - styleOffset)) {
                splitSeg = this.segmentOps.subSequence(segCurrent, segOffset);
                styledSegments.add(new StyledSegment<SEG, S>(splitSeg, styleCurrent.getStyle()));
                segCurrent = segIterator.next();
                segOffset = 0;
                styleOffset += segLength;
                continue;
            }
            if (styleLength < segLength) {
                splitSeg = this.segmentOps.subSequence(segCurrent, segOffset, segOffset + styleLength);
                styledSegments.add(new StyledSegment<SEG, S>(splitSeg, styleCurrent.getStyle()));
                styleCurrent = styleIterator.next();
                styleOffset = 0;
                segOffset += styleLength;
                continue;
            }
            splitSeg = this.segmentOps.subSequence(segCurrent, segOffset, segOffset + styleLength);
            styledSegments.add(new StyledSegment<SEG, S>(splitSeg, styleCurrent.getStyle()));
            if (segIterator.hasNext() && styleIterator.hasNext()) {
                segCurrent = segIterator.next();
                segOffset = 0;
                styleCurrent = styleIterator.next();
                styleOffset = 0;
                continue;
            }
            finished = true;
        }
        return styledSegments;
    }
}

