/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.common;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gatein.api.internal.Parameters;

public class Attributes
extends HashMap<String, String>
implements Serializable {
    private static final String VALUE_OF_METHOD_NAME = "valueOf";
    private static final Map<Class<?>, Method> VALUE_OF_CACHE;
    private static final Class<?>[] VALUE_OF_ARGS;

    public Attributes() {
    }

    public Attributes(Map<String, String> values) {
        super(Parameters.requireNonNull(values, "values"));
    }

    public <T> T get(Key<T> key) {
        Parameters.requireNonNull(key, "key");
        String name = key.getName();
        String value = (String)this.get(name);
        return value != null ? (T)Attributes.fromString(key.getType(), value) : null;
    }

    @Override
    public boolean containsKey(Object key) {
        if (key instanceof Key) {
            try {
                return this.get((Key)key) != null;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return super.containsKey(key);
    }

    @Override
    public <T> T put(Key<T> key, T value) {
        Parameters.requireNonNull(key, "key");
        if (value == null) {
            return this.remove(key);
        }
        if (!key.getType().equals(value.getClass())) {
            throw new IllegalArgumentException("Value class is not the same as key type");
        }
        T oldValue = this.get(key);
        this.put(key.getName(), Attributes.toString(key.getType(), value));
        return oldValue;
    }

    public <T> T remove(Key<T> key) {
        Parameters.requireNonNull(key, "key");
        T oldValue = this.get(key);
        this.remove(key.getName());
        return oldValue;
    }

    public static <T> Key<T> key(String name, Class<T> type) {
        Parameters.requireNonNull(name, "name");
        Parameters.requireNonNull(type, "type");
        if (!type.equals(String.class)) {
            Attributes.getValueOfMethod(type);
        }
        return new Key(name, type);
    }

    protected static <T> T fromString(Class<T> type, String value) {
        if (type.equals(String.class)) {
            return (T)value;
        }
        Method m = Attributes.getValueOfMethod(type);
        try {
            return (T)m.invoke(null, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid type" + type, e);
        }
    }

    protected static <T> String toString(Class<T> type, T value) {
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    private static Method getValueOfMethod(Class<?> c) {
        Method result = VALUE_OF_CACHE.get(c);
        if (result != null) {
            return result;
        }
        try {
            return c.getDeclaredMethod(VALUE_OF_METHOD_NAME, VALUE_OF_ARGS);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Unsupported key type " + (c == null ? "null" : c.getName()) + ". Key type has to either be String or implement 'valueOf(String.class)'", e);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Unsupported key type " + (c == null ? "null" : c.getName()) + ". Key type has to either be String or implement 'valueOf(String.class)'", e);
        }
    }

    static {
        VALUE_OF_ARGS = new Class[]{String.class};
        HashMap<Class<Short>, Method> m = new HashMap<Class<Short>, Method>();
        try {
            m.put(Boolean.class, Boolean.class.getDeclaredMethod(VALUE_OF_METHOD_NAME, VALUE_OF_ARGS));
            m.put(Byte.class, Byte.class.getDeclaredMethod(VALUE_OF_METHOD_NAME, VALUE_OF_ARGS));
            m.put(Double.class, Double.class.getDeclaredMethod(VALUE_OF_METHOD_NAME, VALUE_OF_ARGS));
            m.put(Float.class, Float.class.getDeclaredMethod(VALUE_OF_METHOD_NAME, VALUE_OF_ARGS));
            m.put(Integer.class, Integer.class.getDeclaredMethod(VALUE_OF_METHOD_NAME, VALUE_OF_ARGS));
            m.put(Long.class, Long.class.getDeclaredMethod(VALUE_OF_METHOD_NAME, VALUE_OF_ARGS));
            m.put(Short.class, Short.class.getDeclaredMethod(VALUE_OF_METHOD_NAME, VALUE_OF_ARGS));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not initialize VALUE_OF_CACHE in org.gatein.api.common.Attributes", e);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Could not initialize VALUE_OF_CACHE in org.gatein.api.common.Attributes", e);
        }
        VALUE_OF_CACHE = Collections.unmodifiableMap(m);
    }

    public static class Key<T> {
        private final String name;
        private Class<T> type;

        private Key(String name, Class<T> type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public Class<T> getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key key = (Key)o;
            return this.name.equals(key.name) && this.type.equals(this.type);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.getName();
        }
    }
}

