/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.api.security;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gatein.api.internal.ObjectToStringBuilder;
import org.gatein.api.security.Group;
import org.gatein.api.security.Membership;
import org.gatein.api.security.User;

public class Permission
implements Serializable {
    private static final Permission EVERYONE = new Permission();
    private final Set<Membership> memberships;

    public static Permission everyone() {
        return EVERYONE;
    }

    public static Permission any(String ... group) {
        return new Permission(Membership.any(group));
    }

    public Permission() {
        this.memberships = Collections.emptySet();
    }

    public Permission(String membershipType, Group group) {
        this(new Membership(membershipType, group));
    }

    public Permission(User user) {
        this(new Membership(user));
    }

    public Permission(Membership membership) {
        this(Collections.singleton(membership));
    }

    public Permission(Set<Membership> memberships) {
        this(new LinkedHashSet<Membership>(memberships));
    }

    private Permission(LinkedHashSet<Membership> memberships) {
        this.memberships = memberships;
    }

    public Set<Membership> getMemberships() {
        return Collections.unmodifiableSet(this.memberships);
    }

    public Permission addMembership(Membership membership) {
        LinkedHashSet<Membership> newMemberships = new LinkedHashSet<Membership>(this.memberships.size() + 1);
        newMemberships.addAll(this.memberships);
        newMemberships.add(membership);
        return new Permission(newMemberships);
    }

    public boolean isAccessibleToEveryone() {
        return this.memberships.isEmpty();
    }

    public String toString() {
        return ObjectToStringBuilder.toStringBuilder().add("memberships", this.memberships.isEmpty() ? "Everyone" : this.memberships).toString();
    }

    public int hashCode() {
        return this.memberships != null ? this.memberships.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Permission) {
            Permission other = (Permission)o;
            return this.memberships == other.memberships || this.memberships != null && this.memberships.equals(other.memberships);
        }
        return false;
    }
}

