/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.cdi.wrappers.request;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletRequest;
import javax.portlet.filter.PortletRequestWrapper;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.gatein.cdi.wrappers.PortletSessionWrapper;
import org.gatein.cdi.wrappers.ServletInputStreamWrapper;

public abstract class HttpServletPortletRequestWrapper
extends PortletRequestWrapper
implements HttpServletRequest {
    private PortletRequest request;
    private HttpServletRequestWrapper servletRequest = null;

    public HttpServletPortletRequestWrapper(PortletRequest request) {
        super(request);
        this.request = request;
        try {
            Class<?> clazz = Class.forName("org.gatein.pc.portlet.impl.jsr168.api.PortletRequestImpl");
            Method method = clazz.getMethod("getRealRequest", new Class[0]);
            Object result = method.invoke((Object)request, new Object[0]);
            this.servletRequest = (HttpServletRequestWrapper)result;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getCharacterEncoding() {
        if (null != this.servletRequest) {
            return this.servletRequest.getCharacterEncoding();
        }
        if (this.request instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.request).getCharacterEncoding();
        }
        return null;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (null != this.servletRequest) {
            this.servletRequest.setCharacterEncoding(enc);
        }
        if (this.request instanceof ClientDataRequest) {
            ((ClientDataRequest)this.request).setCharacterEncoding(enc);
        }
    }

    public int getContentLength() {
        if (null != this.servletRequest) {
            return this.servletRequest.getContentLength();
        }
        if (this.request instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.request).getContentLength();
        }
        return 0;
    }

    public String getContentType() {
        if (null != this.servletRequest) {
            return this.servletRequest.getContentType();
        }
        if (this.request instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.request).getContentType();
        }
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (null != this.servletRequest) {
            return this.servletRequest.getInputStream();
        }
        if (this.request instanceof ClientDataRequest) {
            return new ServletInputStreamWrapper((ClientDataRequest)this.request);
        }
        return null;
    }

    public String getProtocol() {
        return "HTTP/1.1";
    }

    public BufferedReader getReader() throws IOException {
        if (null != this.servletRequest) {
            return this.servletRequest.getReader();
        }
        if (this.request instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.request).getReader();
        }
        return null;
    }

    public String getRemoteAddr() {
        if (null != this.servletRequest) {
            return this.servletRequest.getRemoteAddr();
        }
        return null;
    }

    public String getRemoteHost() {
        if (null != this.servletRequest) {
            return this.servletRequest.getRemoteHost();
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (null != this.servletRequest) {
            return this.servletRequest.getRequestDispatcher(path);
        }
        return null;
    }

    @Deprecated
    public String getRealPath(String path) {
        return null;
    }

    public int getRemotePort() {
        if (null != this.servletRequest) {
            return this.servletRequest.getRemotePort();
        }
        return 0;
    }

    public String getLocalName() {
        return this.request.getServerName();
    }

    public String getLocalAddr() {
        if (null != this.servletRequest) {
            return this.servletRequest.getLocalAddr();
        }
        return null;
    }

    public int getLocalPort() {
        return this.request.getServerPort();
    }

    public long getDateHeader(String name) {
        if (null != this.servletRequest) {
            return this.servletRequest.getDateHeader(name);
        }
        SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        try {
            String dateString = this.request.getProperty("If-Modified-Since");
            if (null == dateString || dateString.length() == 0) {
                return -1L;
            }
            Date ifModifiedSinceDate = format.parse(dateString);
            return ifModifiedSinceDate.getTime();
        }
        catch (ParseException ex) {
            return -1L;
        }
    }

    public String getHeader(String name) {
        return this.request.getProperty(name);
    }

    public Enumeration getHeaders(String name) {
        return this.request.getProperties(name);
    }

    public Enumeration getHeaderNames() {
        return this.request.getPropertyNames();
    }

    public int getIntHeader(String name) {
        if (null != this.servletRequest) {
            return this.servletRequest.getIntHeader(name);
        }
        return 0;
    }

    public String getMethod() {
        if (null != this.servletRequest) {
            return this.servletRequest.getMethod();
        }
        if (this.request instanceof ClientDataRequest) {
            return ((ClientDataRequest)this.request).getMethod();
        }
        return null;
    }

    public String getPathInfo() {
        if (null != this.servletRequest) {
            return this.servletRequest.getPathInfo();
        }
        Object obj = this.request.getAttribute("javax.servlet.include.path_info");
        if (null != obj && obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public String getPathTranslated() {
        if (null != this.servletRequest) {
            return this.servletRequest.getPathTranslated();
        }
        return null;
    }

    public String getQueryString() {
        if (null != this.servletRequest) {
            return this.servletRequest.getQueryString();
        }
        Object obj = this.request.getAttribute("javax.servlet.include.query_string");
        if (null != obj && obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public String getRequestURI() {
        if (null != this.servletRequest) {
            return this.servletRequest.getRequestURI();
        }
        Object obj = this.request.getAttribute("javax.servlet.include.request_uri");
        if (null != obj && obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public StringBuffer getRequestURL() {
        if (null != this.servletRequest) {
            return this.servletRequest.getRequestURL();
        }
        return null;
    }

    public String getServletPath() {
        if (null != this.servletRequest) {
            return this.servletRequest.getServletPath();
        }
        Object obj = this.request.getAttribute("javax.servlet.include.servlet_path");
        if (null != obj && obj instanceof String) {
            return (String)obj;
        }
        return null;
    }

    public HttpSession getSession(boolean create) {
        if (null != this.servletRequest) {
            return this.servletRequest.getSession(create);
        }
        return new PortletSessionWrapper(this.request.getPortletSession(create));
    }

    public HttpSession getSession() {
        if (null != this.servletRequest) {
            return this.servletRequest.getSession();
        }
        return new PortletSessionWrapper(this.request.getPortletSession());
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (null != this.servletRequest) {
            return this.servletRequest.isRequestedSessionIdFromCookie();
        }
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (null != this.servletRequest) {
            return this.servletRequest.isRequestedSessionIdFromURL();
        }
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        if (null != this.servletRequest) {
            return this.servletRequest.isRequestedSessionIdFromUrl();
        }
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (null != this.servletRequest) {
            return this.servletRequest.authenticate(response);
        }
        return false;
    }

    public void login(String username, String password) throws ServletException {
        if (null != this.servletRequest) {
            this.servletRequest.login(username, password);
        }
    }

    public void logout() throws ServletException {
        if (null != this.servletRequest) {
            this.servletRequest.logout();
        }
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (null != this.servletRequest) {
            return this.servletRequest.getParts();
        }
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (null != this.servletRequest) {
            return this.servletRequest.getPart(name);
        }
        return null;
    }

    public ServletContext getServletContext() {
        if (null != this.servletRequest) {
            return this.servletRequest.getServletContext();
        }
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (null != this.servletRequest) {
            return this.servletRequest.startAsync();
        }
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (null != servletRequest) {
            return servletRequest.startAsync(servletRequest, servletResponse);
        }
        return null;
    }

    public boolean isAsyncStarted() {
        if (null != this.servletRequest) {
            return this.servletRequest.isAsyncStarted();
        }
        return false;
    }

    public boolean isAsyncSupported() {
        if (null != this.servletRequest) {
            return this.servletRequest.isAsyncSupported();
        }
        return false;
    }

    public AsyncContext getAsyncContext() {
        if (null != this.servletRequest) {
            return this.servletRequest.getAsyncContext();
        }
        return null;
    }

    public DispatcherType getDispatcherType() {
        if (null != this.servletRequest) {
            return this.servletRequest.getDispatcherType();
        }
        return null;
    }
}

